/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SqsAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SqsAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SqsAction.getter(SqsAction::roleArn)).setter(SqsAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> QUEUE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SqsAction.getter(SqsAction::queueUrl)).setter(SqsAction.setter(Builder::queueUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueUrl").build()}).build();
    private static final SdkField<Boolean> USE_BASE64_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SqsAction.getter(SqsAction::useBase64)).setter(SqsAction.setter(Builder::useBase64)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useBase64").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, QUEUE_URL_FIELD, USE_BASE64_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String queueUrl;
    private final Boolean useBase64;

    private SqsAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.queueUrl = builder.queueUrl;
        this.useBase64 = builder.useBase64;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public Boolean useBase64() {
        return this.useBase64;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.useBase64());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqsAction)) {
            return false;
        }
        SqsAction other = (SqsAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.queueUrl(), other.queueUrl()) && Objects.equals(this.useBase64(), other.useBase64());
    }

    public String toString() {
        return ToString.builder((String)"SqsAction").add("RoleArn", (Object)this.roleArn()).add("QueueUrl", (Object)this.queueUrl()).add("UseBase64", (Object)this.useBase64()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "queueUrl": {
                return Optional.ofNullable(clazz.cast(this.queueUrl()));
            }
            case "useBase64": {
                return Optional.ofNullable(clazz.cast(this.useBase64()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqsAction, T> g) {
        return obj -> g.apply((SqsAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String queueUrl;
        private Boolean useBase64;

        private BuilderImpl() {
        }

        private BuilderImpl(SqsAction model) {
            this.roleArn(model.roleArn);
            this.queueUrl(model.queueUrl);
            this.useBase64(model.useBase64);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Boolean getUseBase64() {
            return this.useBase64;
        }

        @Override
        public final Builder useBase64(Boolean useBase64) {
            this.useBase64 = useBase64;
            return this;
        }

        public final void setUseBase64(Boolean useBase64) {
            this.useBase64 = useBase64;
        }

        public SqsAction build() {
            return new SqsAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SqsAction> {
        public Builder roleArn(String var1);

        public Builder queueUrl(String var1);

        public Builder useBase64(Boolean var1);
    }
}

