/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Stream
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Stream> {
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stream.getter(Stream::streamId)).setter(Stream.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<Integer> FILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Stream.getter(Stream::fileId)).setter(Stream.setter(Builder::fileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ID_FIELD, FILE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String streamId;
    private final Integer fileId;

    private Stream(BuilderImpl builder) {
        this.streamId = builder.streamId;
        this.fileId = builder.fileId;
    }

    public String streamId() {
        return this.streamId;
    }

    public Integer fileId() {
        return this.fileId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stream)) {
            return false;
        }
        Stream other = (Stream)obj;
        return Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.fileId(), other.fileId());
    }

    public String toString() {
        return ToString.builder((String)"Stream").add("StreamId", (Object)this.streamId()).add("FileId", (Object)this.fileId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "fileId": {
                return Optional.ofNullable(clazz.cast(this.fileId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Stream, T> g) {
        return obj -> g.apply((Stream)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamId;
        private Integer fileId;

        private BuilderImpl() {
        }

        private BuilderImpl(Stream model) {
            this.streamId(model.streamId);
            this.fileId(model.fileId);
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final Integer getFileId() {
            return this.fileId;
        }

        @Override
        public final Builder fileId(Integer fileId) {
            this.fileId = fileId;
            return this;
        }

        public final void setFileId(Integer fileId) {
            this.fileId = fileId;
        }

        public Stream build() {
            return new Stream(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Stream> {
        public Builder streamId(String var1);

        public Builder fileId(Integer var1);
    }
}

