/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SigningProfileParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SigningProfileParameter> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SigningProfileParameter.getter(SigningProfileParameter::certificateArn)).setter(SigningProfileParameter.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SigningProfileParameter.getter(SigningProfileParameter::platform)).setter(SigningProfileParameter.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> CERTIFICATE_PATH_ON_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SigningProfileParameter.getter(SigningProfileParameter::certificatePathOnDevice)).setter(SigningProfileParameter.setter(Builder::certificatePathOnDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePathOnDevice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, PLATFORM_FIELD, CERTIFICATE_PATH_ON_DEVICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificateArn;
    private final String platform;
    private final String certificatePathOnDevice;

    private SigningProfileParameter(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.platform = builder.platform;
        this.certificatePathOnDevice = builder.certificatePathOnDevice;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String platform() {
        return this.platform;
    }

    public String certificatePathOnDevice() {
        return this.certificatePathOnDevice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePathOnDevice());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningProfileParameter)) {
            return false;
        }
        SigningProfileParameter other = (SigningProfileParameter)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.certificatePathOnDevice(), other.certificatePathOnDevice());
    }

    public String toString() {
        return ToString.builder((String)"SigningProfileParameter").add("CertificateArn", (Object)this.certificateArn()).add("Platform", (Object)this.platform()).add("CertificatePathOnDevice", (Object)this.certificatePathOnDevice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "certificatePathOnDevice": {
                return Optional.ofNullable(clazz.cast(this.certificatePathOnDevice()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningProfileParameter, T> g) {
        return obj -> g.apply((SigningProfileParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String platform;
        private String certificatePathOnDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningProfileParameter model) {
            this.certificateArn(model.certificateArn);
            this.platform(model.platform);
            this.certificatePathOnDevice(model.certificatePathOnDevice);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getCertificatePathOnDevice() {
            return this.certificatePathOnDevice;
        }

        @Override
        public final Builder certificatePathOnDevice(String certificatePathOnDevice) {
            this.certificatePathOnDevice = certificatePathOnDevice;
            return this;
        }

        public final void setCertificatePathOnDevice(String certificatePathOnDevice) {
            this.certificatePathOnDevice = certificatePathOnDevice;
        }

        public SigningProfileParameter build() {
            return new SigningProfileParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SigningProfileParameter> {
        public Builder certificateArn(String var1);

        public Builder platform(String var1);

        public Builder certificatePathOnDevice(String var1);
    }
}

