/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.DimensionValueOperator;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMetricValuesRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ListMetricValuesRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(ListMetricValuesRequest.getter(ListMetricValuesRequest::thingName)).setter(ListMetricValuesRequest.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingName").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(ListMetricValuesRequest.getter(ListMetricValuesRequest::metricName)).setter(ListMetricValuesRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metricName").build()}).build();
    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dimensionName").getter(ListMetricValuesRequest.getter(ListMetricValuesRequest::dimensionName)).setter(ListMetricValuesRequest.setter(Builder::dimensionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dimensionName").build()}).build();
    private static final SdkField<String> DIMENSION_VALUE_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dimensionValueOperator").getter(ListMetricValuesRequest.getter(ListMetricValuesRequest::dimensionValueOperatorAsString)).setter(ListMetricValuesRequest.setter(Builder::dimensionValueOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dimensionValueOperator").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ListMetricValuesRequest.getter(ListMetricValuesRequest::startTime)).setter(ListMetricValuesRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ListMetricValuesRequest.getter(ListMetricValuesRequest::endTime)).setter(ListMetricValuesRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListMetricValuesRequest.getter(ListMetricValuesRequest::maxResults)).setter(ListMetricValuesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMetricValuesRequest.getter(ListMetricValuesRequest::nextToken)).setter(ListMetricValuesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, METRIC_NAME_FIELD, DIMENSION_NAME_FIELD, DIMENSION_VALUE_OPERATOR_FIELD, START_TIME_FIELD, END_TIME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMetricValuesRequest.memberNameToFieldInitializer();
    private final String thingName;
    private final String metricName;
    private final String dimensionName;
    private final String dimensionValueOperator;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer maxResults;
    private final String nextToken;

    private ListMetricValuesRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.metricName = builder.metricName;
        this.dimensionName = builder.dimensionName;
        this.dimensionValueOperator = builder.dimensionValueOperator;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String dimensionName() {
        return this.dimensionName;
    }

    public final DimensionValueOperator dimensionValueOperator() {
        return DimensionValueOperator.fromValue(this.dimensionValueOperator);
    }

    public final String dimensionValueOperatorAsString() {
        return this.dimensionValueOperator;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionValueOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricValuesRequest)) {
            return false;
        }
        ListMetricValuesRequest other = (ListMetricValuesRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.dimensionName(), other.dimensionName()) && Objects.equals(this.dimensionValueOperatorAsString(), other.dimensionValueOperatorAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMetricValuesRequest").add("ThingName", (Object)this.thingName()).add("MetricName", (Object)this.metricName()).add("DimensionName", (Object)this.dimensionName()).add("DimensionValueOperator", (Object)this.dimensionValueOperatorAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "dimensionName": {
                return Optional.ofNullable(clazz.cast(this.dimensionName()));
            }
            case "dimensionValueOperator": {
                return Optional.ofNullable(clazz.cast(this.dimensionValueOperatorAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("thingName", THING_NAME_FIELD);
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("dimensionName", DIMENSION_NAME_FIELD);
        map.put("dimensionValueOperator", DIMENSION_VALUE_OPERATOR_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMetricValuesRequest, T> g) {
        return obj -> g.apply((ListMetricValuesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String thingName;
        private String metricName;
        private String dimensionName;
        private String dimensionValueOperator;
        private Instant startTime;
        private Instant endTime;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricValuesRequest model) {
            super(model);
            this.thingName(model.thingName);
            this.metricName(model.metricName);
            this.dimensionName(model.dimensionName);
            this.dimensionValueOperator(model.dimensionValueOperator);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getThingName() {
            return this.thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getDimensionName() {
            return this.dimensionName;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public final String getDimensionValueOperator() {
            return this.dimensionValueOperator;
        }

        public final void setDimensionValueOperator(String dimensionValueOperator) {
            this.dimensionValueOperator = dimensionValueOperator;
        }

        @Override
        public final Builder dimensionValueOperator(String dimensionValueOperator) {
            this.dimensionValueOperator = dimensionValueOperator;
            return this;
        }

        @Override
        public final Builder dimensionValueOperator(DimensionValueOperator dimensionValueOperator) {
            this.dimensionValueOperator(dimensionValueOperator == null ? null : dimensionValueOperator.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMetricValuesRequest build() {
            return new ListMetricValuesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMetricValuesRequest> {
        public Builder thingName(String var1);

        public Builder metricName(String var1);

        public Builder dimensionName(String var1);

        public Builder dimensionValueOperator(String var1);

        public Builder dimensionValueOperator(DimensionValueOperator var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

