/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.StreamInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStreamResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeStreamResponse> {
    private static final SdkField<StreamInfo> STREAM_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streamInfo").getter(DescribeStreamResponse.getter(DescribeStreamResponse::streamInfo)).setter(DescribeStreamResponse.setter(Builder::streamInfo)).constructor(StreamInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStreamResponse.memberNameToFieldInitializer();
    private final StreamInfo streamInfo;

    private DescribeStreamResponse(BuilderImpl builder) {
        super(builder);
        this.streamInfo = builder.streamInfo;
    }

    public final StreamInfo streamInfo() {
        return this.streamInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamResponse)) {
            return false;
        }
        DescribeStreamResponse other = (DescribeStreamResponse)((Object)obj);
        return Objects.equals(this.streamInfo(), other.streamInfo());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStreamResponse").add("StreamInfo", (Object)this.streamInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamInfo": {
                return Optional.ofNullable(clazz.cast(this.streamInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<StreamInfo>> map = new HashMap<String, SdkField<StreamInfo>>();
        map.put("streamInfo", STREAM_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamResponse, T> g) {
        return obj -> g.apply((DescribeStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private StreamInfo streamInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamResponse model) {
            super(model);
            this.streamInfo(model.streamInfo);
        }

        public final StreamInfo.Builder getStreamInfo() {
            return this.streamInfo != null ? this.streamInfo.toBuilder() : null;
        }

        public final void setStreamInfo(StreamInfo.BuilderImpl streamInfo) {
            this.streamInfo = streamInfo != null ? streamInfo.build() : null;
        }

        @Override
        public final Builder streamInfo(StreamInfo streamInfo) {
            this.streamInfo = streamInfo;
            return this;
        }

        @Override
        public DescribeStreamResponse build() {
            return new DescribeStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStreamResponse> {
        public Builder streamInfo(StreamInfo var1);

        default public Builder streamInfo(Consumer<StreamInfo.Builder> streamInfo) {
            return this.streamInfo((StreamInfo)((StreamInfo.Builder)StreamInfo.builder().applyMutation(streamInfo)).build());
        }
    }
}

