/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PolicyTemplateName {
    BLANK_POLICY("BLANK_POLICY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PolicyTemplateName> VALUE_MAP;
    private final String value;

    private PolicyTemplateName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicyTemplateName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicyTemplateName> knownValues() {
        EnumSet<PolicyTemplateName> knownValues = EnumSet.allOf(PolicyTemplateName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PolicyTemplateName.class, PolicyTemplateName::toString);
    }
}

