/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.HttpUrlDestinationProperties;
import software.amazon.awssdk.services.iot.model.TopicRuleDestinationStatus;
import software.amazon.awssdk.services.iot.model.VpcDestinationProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicRuleDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicRuleDestination> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(TopicRuleDestination.getter(TopicRuleDestination::arn)).setter(TopicRuleDestination.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TopicRuleDestination.getter(TopicRuleDestination::statusAsString)).setter(TopicRuleDestination.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(TopicRuleDestination.getter(TopicRuleDestination::createdAt)).setter(TopicRuleDestination.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(TopicRuleDestination.getter(TopicRuleDestination::lastUpdatedAt)).setter(TopicRuleDestination.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(TopicRuleDestination.getter(TopicRuleDestination::statusReason)).setter(TopicRuleDestination.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<HttpUrlDestinationProperties> HTTP_URL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("httpUrlProperties").getter(TopicRuleDestination.getter(TopicRuleDestination::httpUrlProperties)).setter(TopicRuleDestination.setter(Builder::httpUrlProperties)).constructor(HttpUrlDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpUrlProperties").build()}).build();
    private static final SdkField<VpcDestinationProperties> VPC_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcProperties").getter(TopicRuleDestination.getter(TopicRuleDestination::vpcProperties)).setter(TopicRuleDestination.setter(Builder::vpcProperties)).constructor(VpcDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, STATUS_REASON_FIELD, HTTP_URL_PROPERTIES_FIELD, VPC_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TopicRuleDestination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String status;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String statusReason;
    private final HttpUrlDestinationProperties httpUrlProperties;
    private final VpcDestinationProperties vpcProperties;

    private TopicRuleDestination(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.statusReason = builder.statusReason;
        this.httpUrlProperties = builder.httpUrlProperties;
        this.vpcProperties = builder.vpcProperties;
    }

    public final String arn() {
        return this.arn;
    }

    public final TopicRuleDestinationStatus status() {
        return TopicRuleDestinationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final HttpUrlDestinationProperties httpUrlProperties() {
        return this.httpUrlProperties;
    }

    public final VpcDestinationProperties vpcProperties() {
        return this.vpcProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpUrlProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleDestination)) {
            return false;
        }
        TopicRuleDestination other = (TopicRuleDestination)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.httpUrlProperties(), other.httpUrlProperties()) && Objects.equals(this.vpcProperties(), other.vpcProperties());
    }

    public final String toString() {
        return ToString.builder((String)"TopicRuleDestination").add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("StatusReason", (Object)this.statusReason()).add("HttpUrlProperties", (Object)this.httpUrlProperties()).add("VpcProperties", (Object)this.vpcProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "httpUrlProperties": {
                return Optional.ofNullable(clazz.cast(this.httpUrlProperties()));
            }
            case "vpcProperties": {
                return Optional.ofNullable(clazz.cast(this.vpcProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("httpUrlProperties", HTTP_URL_PROPERTIES_FIELD);
        map.put("vpcProperties", VPC_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicRuleDestination, T> g) {
        return obj -> g.apply((TopicRuleDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String status;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String statusReason;
        private HttpUrlDestinationProperties httpUrlProperties;
        private VpcDestinationProperties vpcProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleDestination model) {
            this.arn(model.arn);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.statusReason(model.statusReason);
            this.httpUrlProperties(model.httpUrlProperties);
            this.vpcProperties(model.vpcProperties);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TopicRuleDestinationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final HttpUrlDestinationProperties.Builder getHttpUrlProperties() {
            return this.httpUrlProperties != null ? this.httpUrlProperties.toBuilder() : null;
        }

        public final void setHttpUrlProperties(HttpUrlDestinationProperties.BuilderImpl httpUrlProperties) {
            this.httpUrlProperties = httpUrlProperties != null ? httpUrlProperties.build() : null;
        }

        @Override
        public final Builder httpUrlProperties(HttpUrlDestinationProperties httpUrlProperties) {
            this.httpUrlProperties = httpUrlProperties;
            return this;
        }

        public final VpcDestinationProperties.Builder getVpcProperties() {
            return this.vpcProperties != null ? this.vpcProperties.toBuilder() : null;
        }

        public final void setVpcProperties(VpcDestinationProperties.BuilderImpl vpcProperties) {
            this.vpcProperties = vpcProperties != null ? vpcProperties.build() : null;
        }

        @Override
        public final Builder vpcProperties(VpcDestinationProperties vpcProperties) {
            this.vpcProperties = vpcProperties;
            return this;
        }

        public TopicRuleDestination build() {
            return new TopicRuleDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicRuleDestination> {
        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(TopicRuleDestinationStatus var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder statusReason(String var1);

        public Builder httpUrlProperties(HttpUrlDestinationProperties var1);

        default public Builder httpUrlProperties(Consumer<HttpUrlDestinationProperties.Builder> httpUrlProperties) {
            return this.httpUrlProperties((HttpUrlDestinationProperties)((HttpUrlDestinationProperties.Builder)HttpUrlDestinationProperties.builder().applyMutation(httpUrlProperties)).build());
        }

        public Builder vpcProperties(VpcDestinationProperties var1);

        default public Builder vpcProperties(Consumer<VpcDestinationProperties.Builder> vpcProperties) {
            return this.vpcProperties((VpcDestinationProperties)((VpcDestinationProperties.Builder)VpcDestinationProperties.builder().applyMutation(vpcProperties)).build());
        }
    }
}

