/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.CommandParameterValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommandParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommandParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CommandParameter.getter(CommandParameter::name)).setter(CommandParameter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<CommandParameterValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(CommandParameter.getter(CommandParameter::value)).setter(CommandParameter.setter(Builder::value)).constructor(CommandParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<CommandParameterValue> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultValue").getter(CommandParameter.getter(CommandParameter::defaultValue)).setter(CommandParameter.setter(Builder::defaultValue)).constructor(CommandParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CommandParameter.getter(CommandParameter::description)).setter(CommandParameter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD, DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CommandParameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final CommandParameterValue value;
    private final CommandParameterValue defaultValue;
    private final String description;

    private CommandParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
    }

    public final String name() {
        return this.name;
    }

    public final CommandParameterValue value() {
        return this.value;
    }

    public final CommandParameterValue defaultValue() {
        return this.defaultValue;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandParameter)) {
            return false;
        }
        CommandParameter other = (CommandParameter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"CommandParameter").add("Name", (Object)this.name()).add("Value", (Object)this.value()).add("DefaultValue", (Object)this.defaultValue()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommandParameter, T> g) {
        return obj -> g.apply((CommandParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private CommandParameterValue value;
        private CommandParameterValue defaultValue;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandParameter model) {
            this.name(model.name);
            this.value(model.value);
            this.defaultValue(model.defaultValue);
            this.description(model.description);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CommandParameterValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(CommandParameterValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(CommandParameterValue value) {
            this.value = value;
            return this;
        }

        public final CommandParameterValue.Builder getDefaultValue() {
            return this.defaultValue != null ? this.defaultValue.toBuilder() : null;
        }

        public final void setDefaultValue(CommandParameterValue.BuilderImpl defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
        }

        @Override
        public final Builder defaultValue(CommandParameterValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public CommandParameter build() {
            return new CommandParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommandParameter> {
        public Builder name(String var1);

        public Builder value(CommandParameterValue var1);

        default public Builder value(Consumer<CommandParameterValue.Builder> value) {
            return this.value((CommandParameterValue)((CommandParameterValue.Builder)CommandParameterValue.builder().applyMutation(value)).build());
        }

        public Builder defaultValue(CommandParameterValue var1);

        default public Builder defaultValue(Consumer<CommandParameterValue.Builder> defaultValue) {
            return this.defaultValue((CommandParameterValue)((CommandParameterValue.Builder)CommandParameterValue.builder().applyMutation(defaultValue)).build());
        }

        public Builder description(String var1);
    }
}

