/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.RateIncreaseCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExponentialRolloutRate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExponentialRolloutRate> {
    private static final SdkField<Integer> BASE_RATE_PER_MINUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("baseRatePerMinute").getter(ExponentialRolloutRate.getter(ExponentialRolloutRate::baseRatePerMinute)).setter(ExponentialRolloutRate.setter(Builder::baseRatePerMinute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseRatePerMinute").build()}).build();
    private static final SdkField<Double> INCREMENT_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("incrementFactor").getter(ExponentialRolloutRate.getter(ExponentialRolloutRate::incrementFactor)).setter(ExponentialRolloutRate.setter(Builder::incrementFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementFactor").build()}).build();
    private static final SdkField<RateIncreaseCriteria> RATE_INCREASE_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rateIncreaseCriteria").getter(ExponentialRolloutRate.getter(ExponentialRolloutRate::rateIncreaseCriteria)).setter(ExponentialRolloutRate.setter(Builder::rateIncreaseCriteria)).constructor(RateIncreaseCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateIncreaseCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_RATE_PER_MINUTE_FIELD, INCREMENT_FACTOR_FIELD, RATE_INCREASE_CRITERIA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExponentialRolloutRate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer baseRatePerMinute;
    private final Double incrementFactor;
    private final RateIncreaseCriteria rateIncreaseCriteria;

    private ExponentialRolloutRate(BuilderImpl builder) {
        this.baseRatePerMinute = builder.baseRatePerMinute;
        this.incrementFactor = builder.incrementFactor;
        this.rateIncreaseCriteria = builder.rateIncreaseCriteria;
    }

    public final Integer baseRatePerMinute() {
        return this.baseRatePerMinute;
    }

    public final Double incrementFactor() {
        return this.incrementFactor;
    }

    public final RateIncreaseCriteria rateIncreaseCriteria() {
        return this.rateIncreaseCriteria;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseRatePerMinute());
        hashCode = 31 * hashCode + Objects.hashCode(this.incrementFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateIncreaseCriteria());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExponentialRolloutRate)) {
            return false;
        }
        ExponentialRolloutRate other = (ExponentialRolloutRate)obj;
        return Objects.equals(this.baseRatePerMinute(), other.baseRatePerMinute()) && Objects.equals(this.incrementFactor(), other.incrementFactor()) && Objects.equals(this.rateIncreaseCriteria(), other.rateIncreaseCriteria());
    }

    public final String toString() {
        return ToString.builder((String)"ExponentialRolloutRate").add("BaseRatePerMinute", (Object)this.baseRatePerMinute()).add("IncrementFactor", (Object)this.incrementFactor()).add("RateIncreaseCriteria", (Object)this.rateIncreaseCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baseRatePerMinute": {
                return Optional.ofNullable(clazz.cast(this.baseRatePerMinute()));
            }
            case "incrementFactor": {
                return Optional.ofNullable(clazz.cast(this.incrementFactor()));
            }
            case "rateIncreaseCriteria": {
                return Optional.ofNullable(clazz.cast(this.rateIncreaseCriteria()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("baseRatePerMinute", BASE_RATE_PER_MINUTE_FIELD);
        map.put("incrementFactor", INCREMENT_FACTOR_FIELD);
        map.put("rateIncreaseCriteria", RATE_INCREASE_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExponentialRolloutRate, T> g) {
        return obj -> g.apply((ExponentialRolloutRate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer baseRatePerMinute;
        private Double incrementFactor;
        private RateIncreaseCriteria rateIncreaseCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(ExponentialRolloutRate model) {
            this.baseRatePerMinute(model.baseRatePerMinute);
            this.incrementFactor(model.incrementFactor);
            this.rateIncreaseCriteria(model.rateIncreaseCriteria);
        }

        public final Integer getBaseRatePerMinute() {
            return this.baseRatePerMinute;
        }

        public final void setBaseRatePerMinute(Integer baseRatePerMinute) {
            this.baseRatePerMinute = baseRatePerMinute;
        }

        @Override
        public final Builder baseRatePerMinute(Integer baseRatePerMinute) {
            this.baseRatePerMinute = baseRatePerMinute;
            return this;
        }

        public final Double getIncrementFactor() {
            return this.incrementFactor;
        }

        public final void setIncrementFactor(Double incrementFactor) {
            this.incrementFactor = incrementFactor;
        }

        @Override
        public final Builder incrementFactor(Double incrementFactor) {
            this.incrementFactor = incrementFactor;
            return this;
        }

        public final RateIncreaseCriteria.Builder getRateIncreaseCriteria() {
            return this.rateIncreaseCriteria != null ? this.rateIncreaseCriteria.toBuilder() : null;
        }

        public final void setRateIncreaseCriteria(RateIncreaseCriteria.BuilderImpl rateIncreaseCriteria) {
            this.rateIncreaseCriteria = rateIncreaseCriteria != null ? rateIncreaseCriteria.build() : null;
        }

        @Override
        public final Builder rateIncreaseCriteria(RateIncreaseCriteria rateIncreaseCriteria) {
            this.rateIncreaseCriteria = rateIncreaseCriteria;
            return this;
        }

        public ExponentialRolloutRate build() {
            return new ExponentialRolloutRate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExponentialRolloutRate> {
        public Builder baseRatePerMinute(Integer var1);

        public Builder incrementFactor(Double var1);

        public Builder rateIncreaseCriteria(RateIncreaseCriteria var1);

        default public Builder rateIncreaseCriteria(Consumer<RateIncreaseCriteria.Builder> rateIncreaseCriteria) {
            return this.rateIncreaseCriteria((RateIncreaseCriteria)((RateIncreaseCriteria.Builder)RateIncreaseCriteria.builder().applyMutation(rateIncreaseCriteria)).build());
        }
    }
}

