/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping;
import software.amazon.awssdk.services.iot.model.SecurityProfileTargetMappingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityProfilesForTargetResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListSecurityProfilesForTargetResponse> {
    private static final SdkField<List<SecurityProfileTargetMapping>> SECURITY_PROFILE_TARGET_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityProfileTargetMappings").getter(ListSecurityProfilesForTargetResponse.getter(ListSecurityProfilesForTargetResponse::securityProfileTargetMappings)).setter(ListSecurityProfilesForTargetResponse.setter(Builder::securityProfileTargetMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileTargetMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityProfileTargetMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSecurityProfilesForTargetResponse.getter(ListSecurityProfilesForTargetResponse::nextToken)).setter(ListSecurityProfilesForTargetResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_TARGET_MAPPINGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSecurityProfilesForTargetResponse.memberNameToFieldInitializer();
    private final List<SecurityProfileTargetMapping> securityProfileTargetMappings;
    private final String nextToken;

    private ListSecurityProfilesForTargetResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileTargetMappings = builder.securityProfileTargetMappings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSecurityProfileTargetMappings() {
        return this.securityProfileTargetMappings != null && !(this.securityProfileTargetMappings instanceof SdkAutoConstructList);
    }

    public final List<SecurityProfileTargetMapping> securityProfileTargetMappings() {
        return this.securityProfileTargetMappings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityProfileTargetMappings() ? this.securityProfileTargetMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfilesForTargetResponse)) {
            return false;
        }
        ListSecurityProfilesForTargetResponse other = (ListSecurityProfilesForTargetResponse)((Object)obj);
        return this.hasSecurityProfileTargetMappings() == other.hasSecurityProfileTargetMappings() && Objects.equals(this.securityProfileTargetMappings(), other.securityProfileTargetMappings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSecurityProfilesForTargetResponse").add("SecurityProfileTargetMappings", this.hasSecurityProfileTargetMappings() ? this.securityProfileTargetMappings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileTargetMappings": {
                return Optional.ofNullable(clazz.cast(this.securityProfileTargetMappings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("securityProfileTargetMappings", SECURITY_PROFILE_TARGET_MAPPINGS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityProfilesForTargetResponse, T> g) {
        return obj -> g.apply((ListSecurityProfilesForTargetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<SecurityProfileTargetMapping> securityProfileTargetMappings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfilesForTargetResponse model) {
            super(model);
            this.securityProfileTargetMappings(model.securityProfileTargetMappings);
            this.nextToken(model.nextToken);
        }

        public final List<SecurityProfileTargetMapping.Builder> getSecurityProfileTargetMappings() {
            List<SecurityProfileTargetMapping.Builder> result = SecurityProfileTargetMappingsCopier.copyToBuilder(this.securityProfileTargetMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityProfileTargetMappings(Collection<SecurityProfileTargetMapping.BuilderImpl> securityProfileTargetMappings) {
            this.securityProfileTargetMappings = SecurityProfileTargetMappingsCopier.copyFromBuilder(securityProfileTargetMappings);
        }

        @Override
        public final Builder securityProfileTargetMappings(Collection<SecurityProfileTargetMapping> securityProfileTargetMappings) {
            this.securityProfileTargetMappings = SecurityProfileTargetMappingsCopier.copy(securityProfileTargetMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileTargetMappings(SecurityProfileTargetMapping ... securityProfileTargetMappings) {
            this.securityProfileTargetMappings(Arrays.asList(securityProfileTargetMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileTargetMappings(Consumer<SecurityProfileTargetMapping.Builder> ... securityProfileTargetMappings) {
            this.securityProfileTargetMappings(Stream.of(securityProfileTargetMappings).map(c -> (SecurityProfileTargetMapping)((SecurityProfileTargetMapping.Builder)SecurityProfileTargetMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSecurityProfilesForTargetResponse build() {
            return new ListSecurityProfilesForTargetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSecurityProfilesForTargetResponse> {
        public Builder securityProfileTargetMappings(Collection<SecurityProfileTargetMapping> var1);

        public Builder securityProfileTargetMappings(SecurityProfileTargetMapping ... var1);

        public Builder securityProfileTargetMappings(Consumer<SecurityProfileTargetMapping.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

