/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.ActiveViolation;
import software.amazon.awssdk.services.iot.model.ActiveViolationsCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActiveViolationsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListActiveViolationsResponse> {
    private static final SdkField<List<ActiveViolation>> ACTIVE_VIOLATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("activeViolations").getter(ListActiveViolationsResponse.getter(ListActiveViolationsResponse::activeViolations)).setter(ListActiveViolationsResponse.setter(Builder::activeViolations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeViolations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActiveViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListActiveViolationsResponse.getter(ListActiveViolationsResponse::nextToken)).setter(ListActiveViolationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_VIOLATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListActiveViolationsResponse.memberNameToFieldInitializer();
    private final List<ActiveViolation> activeViolations;
    private final String nextToken;

    private ListActiveViolationsResponse(BuilderImpl builder) {
        super(builder);
        this.activeViolations = builder.activeViolations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasActiveViolations() {
        return this.activeViolations != null && !(this.activeViolations instanceof SdkAutoConstructList);
    }

    public final List<ActiveViolation> activeViolations() {
        return this.activeViolations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveViolations() ? this.activeViolations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActiveViolationsResponse)) {
            return false;
        }
        ListActiveViolationsResponse other = (ListActiveViolationsResponse)((Object)obj);
        return this.hasActiveViolations() == other.hasActiveViolations() && Objects.equals(this.activeViolations(), other.activeViolations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListActiveViolationsResponse").add("ActiveViolations", this.hasActiveViolations() ? this.activeViolations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeViolations": {
                return Optional.ofNullable(clazz.cast(this.activeViolations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("activeViolations", ACTIVE_VIOLATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListActiveViolationsResponse, T> g) {
        return obj -> g.apply((ListActiveViolationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<ActiveViolation> activeViolations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActiveViolationsResponse model) {
            super(model);
            this.activeViolations(model.activeViolations);
            this.nextToken(model.nextToken);
        }

        public final List<ActiveViolation.Builder> getActiveViolations() {
            List<ActiveViolation.Builder> result = ActiveViolationsCopier.copyToBuilder(this.activeViolations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveViolations(Collection<ActiveViolation.BuilderImpl> activeViolations) {
            this.activeViolations = ActiveViolationsCopier.copyFromBuilder(activeViolations);
        }

        @Override
        public final Builder activeViolations(Collection<ActiveViolation> activeViolations) {
            this.activeViolations = ActiveViolationsCopier.copy(activeViolations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeViolations(ActiveViolation ... activeViolations) {
            this.activeViolations(Arrays.asList(activeViolations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeViolations(Consumer<ActiveViolation.Builder> ... activeViolations) {
            this.activeViolations(Stream.of(activeViolations).map(c -> (ActiveViolation)((ActiveViolation.Builder)ActiveViolation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListActiveViolationsResponse build() {
            return new ListActiveViolationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActiveViolationsResponse> {
        public Builder activeViolations(Collection<ActiveViolation> var1);

        public Builder activeViolations(ActiveViolation ... var1);

        public Builder activeViolations(Consumer<ActiveViolation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

