/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerCertificateConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerCertificateConfig> {
    private static final SdkField<Boolean> ENABLE_OCSP_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableOCSPCheck").getter(ServerCertificateConfig.getter(ServerCertificateConfig::enableOCSPCheck)).setter(ServerCertificateConfig.setter(Builder::enableOCSPCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableOCSPCheck").build()}).build();
    private static final SdkField<String> OCSP_LAMBDA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ocspLambdaArn").getter(ServerCertificateConfig.getter(ServerCertificateConfig::ocspLambdaArn)).setter(ServerCertificateConfig.setter(Builder::ocspLambdaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocspLambdaArn").build()}).build();
    private static final SdkField<String> OCSP_AUTHORIZED_RESPONDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ocspAuthorizedResponderArn").getter(ServerCertificateConfig.getter(ServerCertificateConfig::ocspAuthorizedResponderArn)).setter(ServerCertificateConfig.setter(Builder::ocspAuthorizedResponderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocspAuthorizedResponderArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_OCSP_CHECK_FIELD, OCSP_LAMBDA_ARN_FIELD, OCSP_AUTHORIZED_RESPONDER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServerCertificateConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enableOCSPCheck;
    private final String ocspLambdaArn;
    private final String ocspAuthorizedResponderArn;

    private ServerCertificateConfig(BuilderImpl builder) {
        this.enableOCSPCheck = builder.enableOCSPCheck;
        this.ocspLambdaArn = builder.ocspLambdaArn;
        this.ocspAuthorizedResponderArn = builder.ocspAuthorizedResponderArn;
    }

    public final Boolean enableOCSPCheck() {
        return this.enableOCSPCheck;
    }

    public final String ocspLambdaArn() {
        return this.ocspLambdaArn;
    }

    public final String ocspAuthorizedResponderArn() {
        return this.ocspAuthorizedResponderArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableOCSPCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.ocspLambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ocspAuthorizedResponderArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerCertificateConfig)) {
            return false;
        }
        ServerCertificateConfig other = (ServerCertificateConfig)obj;
        return Objects.equals(this.enableOCSPCheck(), other.enableOCSPCheck()) && Objects.equals(this.ocspLambdaArn(), other.ocspLambdaArn()) && Objects.equals(this.ocspAuthorizedResponderArn(), other.ocspAuthorizedResponderArn());
    }

    public final String toString() {
        return ToString.builder((String)"ServerCertificateConfig").add("EnableOCSPCheck", (Object)this.enableOCSPCheck()).add("OcspLambdaArn", (Object)this.ocspLambdaArn()).add("OcspAuthorizedResponderArn", (Object)this.ocspAuthorizedResponderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enableOCSPCheck": {
                return Optional.ofNullable(clazz.cast(this.enableOCSPCheck()));
            }
            case "ocspLambdaArn": {
                return Optional.ofNullable(clazz.cast(this.ocspLambdaArn()));
            }
            case "ocspAuthorizedResponderArn": {
                return Optional.ofNullable(clazz.cast(this.ocspAuthorizedResponderArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enableOCSPCheck", ENABLE_OCSP_CHECK_FIELD);
        map.put("ocspLambdaArn", OCSP_LAMBDA_ARN_FIELD);
        map.put("ocspAuthorizedResponderArn", OCSP_AUTHORIZED_RESPONDER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerCertificateConfig, T> g) {
        return obj -> g.apply((ServerCertificateConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableOCSPCheck;
        private String ocspLambdaArn;
        private String ocspAuthorizedResponderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerCertificateConfig model) {
            this.enableOCSPCheck(model.enableOCSPCheck);
            this.ocspLambdaArn(model.ocspLambdaArn);
            this.ocspAuthorizedResponderArn(model.ocspAuthorizedResponderArn);
        }

        public final Boolean getEnableOCSPCheck() {
            return this.enableOCSPCheck;
        }

        public final void setEnableOCSPCheck(Boolean enableOCSPCheck) {
            this.enableOCSPCheck = enableOCSPCheck;
        }

        @Override
        public final Builder enableOCSPCheck(Boolean enableOCSPCheck) {
            this.enableOCSPCheck = enableOCSPCheck;
            return this;
        }

        public final String getOcspLambdaArn() {
            return this.ocspLambdaArn;
        }

        public final void setOcspLambdaArn(String ocspLambdaArn) {
            this.ocspLambdaArn = ocspLambdaArn;
        }

        @Override
        public final Builder ocspLambdaArn(String ocspLambdaArn) {
            this.ocspLambdaArn = ocspLambdaArn;
            return this;
        }

        public final String getOcspAuthorizedResponderArn() {
            return this.ocspAuthorizedResponderArn;
        }

        public final void setOcspAuthorizedResponderArn(String ocspAuthorizedResponderArn) {
            this.ocspAuthorizedResponderArn = ocspAuthorizedResponderArn;
        }

        @Override
        public final Builder ocspAuthorizedResponderArn(String ocspAuthorizedResponderArn) {
            this.ocspAuthorizedResponderArn = ocspAuthorizedResponderArn;
            return this;
        }

        public ServerCertificateConfig build() {
            return new ServerCertificateConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerCertificateConfig> {
        public Builder enableOCSPCheck(Boolean var1);

        public Builder ocspLambdaArn(String var1);

        public Builder ocspAuthorizedResponderArn(String var1);
    }
}

