/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransferCertificateRequest
extends IotRequest
implements ToCopyableBuilder<Builder, TransferCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateId").getter(TransferCertificateRequest.getter(TransferCertificateRequest::certificateId)).setter(TransferCertificateRequest.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("certificateId").build()}).build();
    private static final SdkField<String> TARGET_AWS_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetAwsAccount").getter(TransferCertificateRequest.getter(TransferCertificateRequest::targetAwsAccount)).setter(TransferCertificateRequest.setter(Builder::targetAwsAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetAwsAccount").build()}).build();
    private static final SdkField<String> TRANSFER_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transferMessage").getter(TransferCertificateRequest.getter(TransferCertificateRequest::transferMessage)).setter(TransferCertificateRequest.setter(Builder::transferMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD, TARGET_AWS_ACCOUNT_FIELD, TRANSFER_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("certificateId", CERTIFICATE_ID_FIELD);
            this.put("targetAwsAccount", TARGET_AWS_ACCOUNT_FIELD);
            this.put("transferMessage", TRANSFER_MESSAGE_FIELD);
        }
    });
    private final String certificateId;
    private final String targetAwsAccount;
    private final String transferMessage;

    private TransferCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.targetAwsAccount = builder.targetAwsAccount;
        this.transferMessage = builder.transferMessage;
    }

    public final String certificateId() {
        return this.certificateId;
    }

    public final String targetAwsAccount() {
        return this.targetAwsAccount;
    }

    public final String transferMessage() {
        return this.transferMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAwsAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferCertificateRequest)) {
            return false;
        }
        TransferCertificateRequest other = (TransferCertificateRequest)((Object)obj);
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.targetAwsAccount(), other.targetAwsAccount()) && Objects.equals(this.transferMessage(), other.transferMessage());
    }

    public final String toString() {
        return ToString.builder((String)"TransferCertificateRequest").add("CertificateId", (Object)this.certificateId()).add("TargetAwsAccount", (Object)this.targetAwsAccount()).add("TransferMessage", (Object)this.transferMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "targetAwsAccount": {
                return Optional.ofNullable(clazz.cast(this.targetAwsAccount()));
            }
            case "transferMessage": {
                return Optional.ofNullable(clazz.cast(this.transferMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TransferCertificateRequest, T> g) {
        return obj -> g.apply((TransferCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String certificateId;
        private String targetAwsAccount;
        private String transferMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferCertificateRequest model) {
            super(model);
            this.certificateId(model.certificateId);
            this.targetAwsAccount(model.targetAwsAccount);
            this.transferMessage(model.transferMessage);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getTargetAwsAccount() {
            return this.targetAwsAccount;
        }

        public final void setTargetAwsAccount(String targetAwsAccount) {
            this.targetAwsAccount = targetAwsAccount;
        }

        @Override
        public final Builder targetAwsAccount(String targetAwsAccount) {
            this.targetAwsAccount = targetAwsAccount;
            return this;
        }

        public final String getTransferMessage() {
            return this.transferMessage;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        @Override
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TransferCertificateRequest build() {
            return new TransferCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TransferCertificateRequest> {
        public Builder certificateId(String var1);

        public Builder targetAwsAccount(String var1);

        public Builder transferMessage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

