/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.ResourceIdentifier;
import software.amazon.awssdk.services.iot.model.ResourceType;
import software.amazon.awssdk.services.iot.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NonCompliantResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NonCompliantResource> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(NonCompliantResource.getter(NonCompliantResource::resourceTypeAsString)).setter(NonCompliantResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<ResourceIdentifier> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceIdentifier").getter(NonCompliantResource.getter(NonCompliantResource::resourceIdentifier)).setter(NonCompliantResource.setter(Builder::resourceIdentifier)).constructor(ResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalInfo").getter(NonCompliantResource.getter(NonCompliantResource::additionalInfo)).setter(NonCompliantResource.setter(Builder::additionalInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInfo").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_IDENTIFIER_FIELD, ADDITIONAL_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceType", RESOURCE_TYPE_FIELD);
            this.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
            this.put("additionalInfo", ADDITIONAL_INFO_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final ResourceIdentifier resourceIdentifier;
    private final Map<String, String> additionalInfo;

    private NonCompliantResource(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.additionalInfo = builder.additionalInfo;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final ResourceIdentifier resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final boolean hasAdditionalInfo() {
        return this.additionalInfo != null && !(this.additionalInfo instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalInfo() {
        return this.additionalInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalInfo() ? this.additionalInfo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NonCompliantResource)) {
            return false;
        }
        NonCompliantResource other = (NonCompliantResource)obj;
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && this.hasAdditionalInfo() == other.hasAdditionalInfo() && Objects.equals(this.additionalInfo(), other.additionalInfo());
    }

    public final String toString() {
        return ToString.builder((String)"NonCompliantResource").add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("AdditionalInfo", this.hasAdditionalInfo() ? this.additionalInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "additionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NonCompliantResource, T> g) {
        return obj -> g.apply((NonCompliantResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private ResourceIdentifier resourceIdentifier;
        private Map<String, String> additionalInfo = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NonCompliantResource model) {
            this.resourceType(model.resourceType);
            this.resourceIdentifier(model.resourceIdentifier);
            this.additionalInfo(model.additionalInfo);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final ResourceIdentifier.Builder getResourceIdentifier() {
            return this.resourceIdentifier != null ? this.resourceIdentifier.toBuilder() : null;
        }

        public final void setResourceIdentifier(ResourceIdentifier.BuilderImpl resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier != null ? resourceIdentifier.build() : null;
        }

        @Override
        public final Builder resourceIdentifier(ResourceIdentifier resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Map<String, String> getAdditionalInfo() {
            if (this.additionalInfo instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalInfo;
        }

        public final void setAdditionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = StringMapCopier.copy(additionalInfo);
        }

        @Override
        public final Builder additionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = StringMapCopier.copy(additionalInfo);
            return this;
        }

        public NonCompliantResource build() {
            return new NonCompliantResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NonCompliantResource> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceIdentifier(ResourceIdentifier var1);

        default public Builder resourceIdentifier(Consumer<ResourceIdentifier.Builder> resourceIdentifier) {
            return this.resourceIdentifier((ResourceIdentifier)((ResourceIdentifier.Builder)ResourceIdentifier.builder().applyMutation(resourceIdentifier)).build());
        }

        public Builder additionalInfo(Map<String, String> var1);
    }
}

