/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.TimestreamDimension;
import software.amazon.awssdk.services.iot.model.TimestreamDimensionListCopier;
import software.amazon.awssdk.services.iot.model.TimestreamTimestamp;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimestreamAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimestreamAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(TimestreamAction.getter(TimestreamAction::roleArn)).setter(TimestreamAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(TimestreamAction.getter(TimestreamAction::databaseName)).setter(TimestreamAction.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableName").getter(TimestreamAction.getter(TimestreamAction::tableName)).setter(TimestreamAction.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final SdkField<List<TimestreamDimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dimensions").getter(TimestreamAction.getter(TimestreamAction::dimensions)).setter(TimestreamAction.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimestreamDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimestreamTimestamp> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timestamp").getter(TimestreamAction.getter(TimestreamAction::timestamp)).setter(TimestreamAction.setter(Builder::timestamp)).constructor(TimestreamTimestamp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, DIMENSIONS_FIELD, TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TimestreamAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String databaseName;
    private final String tableName;
    private final List<TimestreamDimension> dimensions;
    private final TimestreamTimestamp timestamp;

    private TimestreamAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.dimensions = builder.dimensions;
        this.timestamp = builder.timestamp;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<TimestreamDimension> dimensions() {
        return this.dimensions;
    }

    public final TimestreamTimestamp timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestreamAction)) {
            return false;
        }
        TimestreamAction other = (TimestreamAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"TimestreamAction").add("RoleArn", (Object)this.roleArn()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("tableName", TABLE_NAME_FIELD);
        map.put("dimensions", DIMENSIONS_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimestreamAction, T> g) {
        return obj -> g.apply((TimestreamAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String databaseName;
        private String tableName;
        private List<TimestreamDimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private TimestreamTimestamp timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestreamAction model) {
            this.roleArn(model.roleArn);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.dimensions(model.dimensions);
            this.timestamp(model.timestamp);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final List<TimestreamDimension.Builder> getDimensions() {
            List<TimestreamDimension.Builder> result = TimestreamDimensionListCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<TimestreamDimension.BuilderImpl> dimensions) {
            this.dimensions = TimestreamDimensionListCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<TimestreamDimension> dimensions) {
            this.dimensions = TimestreamDimensionListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(TimestreamDimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<TimestreamDimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (TimestreamDimension)((TimestreamDimension.Builder)TimestreamDimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TimestreamTimestamp.Builder getTimestamp() {
            return this.timestamp != null ? this.timestamp.toBuilder() : null;
        }

        public final void setTimestamp(TimestreamTimestamp.BuilderImpl timestamp) {
            this.timestamp = timestamp != null ? timestamp.build() : null;
        }

        @Override
        public final Builder timestamp(TimestreamTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public TimestreamAction build() {
            return new TimestreamAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimestreamAction> {
        public Builder roleArn(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder dimensions(Collection<TimestreamDimension> var1);

        public Builder dimensions(TimestreamDimension ... var1);

        public Builder dimensions(Consumer<TimestreamDimension.Builder> ... var1);

        public Builder timestamp(TimestreamTimestamp var1);

        default public Builder timestamp(Consumer<TimestreamTimestamp.Builder> timestamp) {
            return this.timestamp((TimestreamTimestamp)((TimestreamTimestamp.Builder)TimestreamTimestamp.builder().applyMutation(timestamp)).build());
        }
    }
}

