/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.OTAUpdateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOtaUpdateResponse
extends IotResponse
implements ToCopyableBuilder<Builder, CreateOtaUpdateResponse> {
    private static final SdkField<String> OTA_UPDATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("otaUpdateId").getter(CreateOtaUpdateResponse.getter(CreateOtaUpdateResponse::otaUpdateId)).setter(CreateOtaUpdateResponse.setter(Builder::otaUpdateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateId").build()}).build();
    private static final SdkField<String> AWS_IOT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsIotJobId").getter(CreateOtaUpdateResponse.getter(CreateOtaUpdateResponse::awsIotJobId)).setter(CreateOtaUpdateResponse.setter(Builder::awsIotJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIotJobId").build()}).build();
    private static final SdkField<String> OTA_UPDATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("otaUpdateArn").getter(CreateOtaUpdateResponse.getter(CreateOtaUpdateResponse::otaUpdateArn)).setter(CreateOtaUpdateResponse.setter(Builder::otaUpdateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateArn").build()}).build();
    private static final SdkField<String> AWS_IOT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsIotJobArn").getter(CreateOtaUpdateResponse.getter(CreateOtaUpdateResponse::awsIotJobArn)).setter(CreateOtaUpdateResponse.setter(Builder::awsIotJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIotJobArn").build()}).build();
    private static final SdkField<String> OTA_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("otaUpdateStatus").getter(CreateOtaUpdateResponse.getter(CreateOtaUpdateResponse::otaUpdateStatusAsString)).setter(CreateOtaUpdateResponse.setter(Builder::otaUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_UPDATE_ID_FIELD, AWS_IOT_JOB_ID_FIELD, OTA_UPDATE_ARN_FIELD, AWS_IOT_JOB_ARN_FIELD, OTA_UPDATE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateOtaUpdateResponse.memberNameToFieldInitializer();
    private final String otaUpdateId;
    private final String awsIotJobId;
    private final String otaUpdateArn;
    private final String awsIotJobArn;
    private final String otaUpdateStatus;

    private CreateOtaUpdateResponse(BuilderImpl builder) {
        super(builder);
        this.otaUpdateId = builder.otaUpdateId;
        this.awsIotJobId = builder.awsIotJobId;
        this.otaUpdateArn = builder.otaUpdateArn;
        this.awsIotJobArn = builder.awsIotJobArn;
        this.otaUpdateStatus = builder.otaUpdateStatus;
    }

    public final String otaUpdateId() {
        return this.otaUpdateId;
    }

    public final String awsIotJobId() {
        return this.awsIotJobId;
    }

    public final String otaUpdateArn() {
        return this.otaUpdateArn;
    }

    public final String awsIotJobArn() {
        return this.awsIotJobArn;
    }

    public final OTAUpdateStatus otaUpdateStatus() {
        return OTAUpdateStatus.fromValue(this.otaUpdateStatus);
    }

    public final String otaUpdateStatusAsString() {
        return this.otaUpdateStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIotJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOtaUpdateResponse)) {
            return false;
        }
        CreateOtaUpdateResponse other = (CreateOtaUpdateResponse)((Object)obj);
        return Objects.equals(this.otaUpdateId(), other.otaUpdateId()) && Objects.equals(this.awsIotJobId(), other.awsIotJobId()) && Objects.equals(this.otaUpdateArn(), other.otaUpdateArn()) && Objects.equals(this.awsIotJobArn(), other.awsIotJobArn()) && Objects.equals(this.otaUpdateStatusAsString(), other.otaUpdateStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOtaUpdateResponse").add("OtaUpdateId", (Object)this.otaUpdateId()).add("AwsIotJobId", (Object)this.awsIotJobId()).add("OtaUpdateArn", (Object)this.otaUpdateArn()).add("AwsIotJobArn", (Object)this.awsIotJobArn()).add("OtaUpdateStatus", (Object)this.otaUpdateStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "otaUpdateId": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateId()));
            }
            case "awsIotJobId": {
                return Optional.ofNullable(clazz.cast(this.awsIotJobId()));
            }
            case "otaUpdateArn": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateArn()));
            }
            case "awsIotJobArn": {
                return Optional.ofNullable(clazz.cast(this.awsIotJobArn()));
            }
            case "otaUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("otaUpdateId", OTA_UPDATE_ID_FIELD);
        map.put("awsIotJobId", AWS_IOT_JOB_ID_FIELD);
        map.put("otaUpdateArn", OTA_UPDATE_ARN_FIELD);
        map.put("awsIotJobArn", AWS_IOT_JOB_ARN_FIELD);
        map.put("otaUpdateStatus", OTA_UPDATE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOtaUpdateResponse, T> g) {
        return obj -> g.apply((CreateOtaUpdateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String otaUpdateId;
        private String awsIotJobId;
        private String otaUpdateArn;
        private String awsIotJobArn;
        private String otaUpdateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOtaUpdateResponse model) {
            super(model);
            this.otaUpdateId(model.otaUpdateId);
            this.awsIotJobId(model.awsIotJobId);
            this.otaUpdateArn(model.otaUpdateArn);
            this.awsIotJobArn(model.awsIotJobArn);
            this.otaUpdateStatus(model.otaUpdateStatus);
        }

        public final String getOtaUpdateId() {
            return this.otaUpdateId;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final String getAwsIotJobId() {
            return this.awsIotJobId;
        }

        public final void setAwsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
        }

        @Override
        public final Builder awsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
            return this;
        }

        public final String getOtaUpdateArn() {
            return this.otaUpdateArn;
        }

        public final void setOtaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
        }

        @Override
        public final Builder otaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
            return this;
        }

        public final String getAwsIotJobArn() {
            return this.awsIotJobArn;
        }

        public final void setAwsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
        }

        @Override
        public final Builder awsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
            return this;
        }

        public final String getOtaUpdateStatus() {
            return this.otaUpdateStatus;
        }

        public final void setOtaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
        }

        @Override
        public final Builder otaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
            return this;
        }

        @Override
        public final Builder otaUpdateStatus(OTAUpdateStatus otaUpdateStatus) {
            this.otaUpdateStatus(otaUpdateStatus == null ? null : otaUpdateStatus.toString());
            return this;
        }

        @Override
        public CreateOtaUpdateResponse build() {
            return new CreateOtaUpdateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOtaUpdateResponse> {
        public Builder otaUpdateId(String var1);

        public Builder awsIotJobId(String var1);

        public Builder otaUpdateArn(String var1);

        public Builder awsIotJobArn(String var1);

        public Builder otaUpdateStatus(String var1);

        public Builder otaUpdateStatus(OTAUpdateStatus var1);
    }
}

