/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.CidrsCopier;
import software.amazon.awssdk.services.iot.model.NumberListCopier;
import software.amazon.awssdk.services.iot.model.PortsCopier;
import software.amazon.awssdk.services.iot.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricValue> {
    private static final SdkField<Long> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("count").getter(MetricValue.getter(MetricValue::count)).setter(MetricValue.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<List<String>> CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cidrs").getter(MetricValue.getter(MetricValue::cidrs)).setter(MetricValue.setter(Builder::cidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ports").getter(MetricValue.getter(MetricValue::ports)).setter(MetricValue.setter(Builder::ports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("number").getter(MetricValue.getter(MetricValue::number)).setter(MetricValue.setter(Builder::number)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("number").build()}).build();
    private static final SdkField<List<Double>> NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("numbers").getter(MetricValue.getter(MetricValue::numbers)).setter(MetricValue.setter(Builder::numbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STRINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("strings").getter(MetricValue.getter(MetricValue::strings)).setter(MetricValue.setter(Builder::strings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, CIDRS_FIELD, PORTS_FIELD, NUMBER_FIELD, NUMBERS_FIELD, STRINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("count", COUNT_FIELD);
            this.put("cidrs", CIDRS_FIELD);
            this.put("ports", PORTS_FIELD);
            this.put("number", NUMBER_FIELD);
            this.put("numbers", NUMBERS_FIELD);
            this.put("strings", STRINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long count;
    private final List<String> cidrs;
    private final List<Integer> ports;
    private final Double number;
    private final List<Double> numbers;
    private final List<String> strings;

    private MetricValue(BuilderImpl builder) {
        this.count = builder.count;
        this.cidrs = builder.cidrs;
        this.ports = builder.ports;
        this.number = builder.number;
        this.numbers = builder.numbers;
        this.strings = builder.strings;
    }

    public final Long count() {
        return this.count;
    }

    public final boolean hasCidrs() {
        return this.cidrs != null && !(this.cidrs instanceof SdkAutoConstructList);
    }

    public final List<String> cidrs() {
        return this.cidrs;
    }

    public final boolean hasPorts() {
        return this.ports != null && !(this.ports instanceof SdkAutoConstructList);
    }

    public final List<Integer> ports() {
        return this.ports;
    }

    public final Double number() {
        return this.number;
    }

    public final boolean hasNumbers() {
        return this.numbers != null && !(this.numbers instanceof SdkAutoConstructList);
    }

    public final List<Double> numbers() {
        return this.numbers;
    }

    public final boolean hasStrings() {
        return this.strings != null && !(this.strings instanceof SdkAutoConstructList);
    }

    public final List<String> strings() {
        return this.strings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrs() ? this.cidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPorts() ? this.ports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.number());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNumbers() ? this.numbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStrings() ? this.strings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricValue)) {
            return false;
        }
        MetricValue other = (MetricValue)obj;
        return Objects.equals(this.count(), other.count()) && this.hasCidrs() == other.hasCidrs() && Objects.equals(this.cidrs(), other.cidrs()) && this.hasPorts() == other.hasPorts() && Objects.equals(this.ports(), other.ports()) && Objects.equals(this.number(), other.number()) && this.hasNumbers() == other.hasNumbers() && Objects.equals(this.numbers(), other.numbers()) && this.hasStrings() == other.hasStrings() && Objects.equals(this.strings(), other.strings());
    }

    public final String toString() {
        return ToString.builder((String)"MetricValue").add("Count", (Object)this.count()).add("Cidrs", this.hasCidrs() ? this.cidrs() : null).add("Ports", this.hasPorts() ? this.ports() : null).add("Number", (Object)this.number()).add("Numbers", this.hasNumbers() ? this.numbers() : null).add("Strings", this.hasStrings() ? this.strings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "cidrs": {
                return Optional.ofNullable(clazz.cast(this.cidrs()));
            }
            case "ports": {
                return Optional.ofNullable(clazz.cast(this.ports()));
            }
            case "number": {
                return Optional.ofNullable(clazz.cast(this.number()));
            }
            case "numbers": {
                return Optional.ofNullable(clazz.cast(this.numbers()));
            }
            case "strings": {
                return Optional.ofNullable(clazz.cast(this.strings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetricValue, T> g) {
        return obj -> g.apply((MetricValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long count;
        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> ports = DefaultSdkAutoConstructList.getInstance();
        private Double number;
        private List<Double> numbers = DefaultSdkAutoConstructList.getInstance();
        private List<String> strings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricValue model) {
            this.count(model.count);
            this.cidrs(model.cidrs);
            this.ports(model.ports);
            this.number(model.number);
            this.numbers(model.numbers);
            this.strings(model.strings);
        }

        public final Long getCount() {
            return this.count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final Collection<String> getCidrs() {
            if (this.cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrs;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = CidrsCopier.copy(cidrs);
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = CidrsCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String ... cidrs) {
            this.cidrs(Arrays.asList(cidrs));
            return this;
        }

        public final Collection<Integer> getPorts() {
            if (this.ports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ports;
        }

        public final void setPorts(Collection<Integer> ports) {
            this.ports = PortsCopier.copy(ports);
        }

        @Override
        public final Builder ports(Collection<Integer> ports) {
            this.ports = PortsCopier.copy(ports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ports(Integer ... ports) {
            this.ports(Arrays.asList(ports));
            return this;
        }

        public final Double getNumber() {
            return this.number;
        }

        public final void setNumber(Double number) {
            this.number = number;
        }

        @Override
        public final Builder number(Double number) {
            this.number = number;
            return this;
        }

        public final Collection<Double> getNumbers() {
            if (this.numbers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.numbers;
        }

        public final void setNumbers(Collection<Double> numbers) {
            this.numbers = NumberListCopier.copy(numbers);
        }

        @Override
        public final Builder numbers(Collection<Double> numbers) {
            this.numbers = NumberListCopier.copy(numbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numbers(Double ... numbers) {
            this.numbers(Arrays.asList(numbers));
            return this;
        }

        public final Collection<String> getStrings() {
            if (this.strings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.strings;
        }

        public final void setStrings(Collection<String> strings) {
            this.strings = StringListCopier.copy(strings);
        }

        @Override
        public final Builder strings(Collection<String> strings) {
            this.strings = StringListCopier.copy(strings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder strings(String ... strings) {
            this.strings(Arrays.asList(strings));
            return this;
        }

        public MetricValue build() {
            return new MetricValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricValue> {
        public Builder count(Long var1);

        public Builder cidrs(Collection<String> var1);

        public Builder cidrs(String ... var1);

        public Builder ports(Collection<Integer> var1);

        public Builder ports(Integer ... var1);

        public Builder number(Double var1);

        public Builder numbers(Collection<Double> var1);

        public Builder numbers(Double ... var1);

        public Builder strings(Collection<String> var1);

        public Builder strings(String ... var1);
    }
}

