/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AttributePayload;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateThingRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateThingRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(UpdateThingRequest.getter(UpdateThingRequest::thingName)).setter(UpdateThingRequest.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()}).build();
    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingTypeName").getter(UpdateThingRequest.getter(UpdateThingRequest::thingTypeName)).setter(UpdateThingRequest.setter(Builder::thingTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()}).build();
    private static final SdkField<AttributePayload> ATTRIBUTE_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attributePayload").getter(UpdateThingRequest.getter(UpdateThingRequest::attributePayload)).setter(UpdateThingRequest.setter(Builder::attributePayload)).constructor(AttributePayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributePayload").build()}).build();
    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("expectedVersion").getter(UpdateThingRequest.getter(UpdateThingRequest::expectedVersion)).setter(UpdateThingRequest.setter(Builder::expectedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedVersion").build()}).build();
    private static final SdkField<Boolean> REMOVE_THING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("removeThingType").getter(UpdateThingRequest.getter(UpdateThingRequest::removeThingType)).setter(UpdateThingRequest.setter(Builder::removeThingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeThingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, THING_TYPE_NAME_FIELD, ATTRIBUTE_PAYLOAD_FIELD, EXPECTED_VERSION_FIELD, REMOVE_THING_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("thingName", THING_NAME_FIELD);
            this.put("thingTypeName", THING_TYPE_NAME_FIELD);
            this.put("attributePayload", ATTRIBUTE_PAYLOAD_FIELD);
            this.put("expectedVersion", EXPECTED_VERSION_FIELD);
            this.put("removeThingType", REMOVE_THING_TYPE_FIELD);
        }
    });
    private final String thingName;
    private final String thingTypeName;
    private final AttributePayload attributePayload;
    private final Long expectedVersion;
    private final Boolean removeThingType;

    private UpdateThingRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributePayload = builder.attributePayload;
        this.expectedVersion = builder.expectedVersion;
        this.removeThingType = builder.removeThingType;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final String thingTypeName() {
        return this.thingTypeName;
    }

    public final AttributePayload attributePayload() {
        return this.attributePayload;
    }

    public final Long expectedVersion() {
        return this.expectedVersion;
    }

    public final Boolean removeThingType() {
        return this.removeThingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributePayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeThingType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingRequest)) {
            return false;
        }
        UpdateThingRequest other = (UpdateThingRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingTypeName(), other.thingTypeName()) && Objects.equals(this.attributePayload(), other.attributePayload()) && Objects.equals(this.expectedVersion(), other.expectedVersion()) && Objects.equals(this.removeThingType(), other.removeThingType());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateThingRequest").add("ThingName", (Object)this.thingName()).add("ThingTypeName", (Object)this.thingTypeName()).add("AttributePayload", (Object)this.attributePayload()).add("ExpectedVersion", (Object)this.expectedVersion()).add("RemoveThingType", (Object)this.removeThingType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "thingTypeName": {
                return Optional.ofNullable(clazz.cast(this.thingTypeName()));
            }
            case "attributePayload": {
                return Optional.ofNullable(clazz.cast(this.attributePayload()));
            }
            case "expectedVersion": {
                return Optional.ofNullable(clazz.cast(this.expectedVersion()));
            }
            case "removeThingType": {
                return Optional.ofNullable(clazz.cast(this.removeThingType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateThingRequest, T> g) {
        return obj -> g.apply((UpdateThingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String thingName;
        private String thingTypeName;
        private AttributePayload attributePayload;
        private Long expectedVersion;
        private Boolean removeThingType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingRequest model) {
            super(model);
            this.thingName(model.thingName);
            this.thingTypeName(model.thingTypeName);
            this.attributePayload(model.attributePayload);
            this.expectedVersion(model.expectedVersion);
            this.removeThingType(model.removeThingType);
        }

        public final String getThingName() {
            return this.thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final AttributePayload.Builder getAttributePayload() {
            return this.attributePayload != null ? this.attributePayload.toBuilder() : null;
        }

        public final void setAttributePayload(AttributePayload.BuilderImpl attributePayload) {
            this.attributePayload = attributePayload != null ? attributePayload.build() : null;
        }

        @Override
        public final Builder attributePayload(AttributePayload attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        public final Long getExpectedVersion() {
            return this.expectedVersion;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final Boolean getRemoveThingType() {
            return this.removeThingType;
        }

        public final void setRemoveThingType(Boolean removeThingType) {
            this.removeThingType = removeThingType;
        }

        @Override
        public final Builder removeThingType(Boolean removeThingType) {
            this.removeThingType = removeThingType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThingRequest build() {
            return new UpdateThingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateThingRequest> {
        public Builder thingName(String var1);

        public Builder thingTypeName(String var1);

        public Builder attributePayload(AttributePayload var1);

        default public Builder attributePayload(Consumer<AttributePayload.Builder> attributePayload) {
            return this.attributePayload((AttributePayload)((AttributePayload.Builder)AttributePayload.builder().applyMutation(attributePayload)).build());
        }

        public Builder expectedVersion(Long var1);

        public Builder removeThingType(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

