/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.CertificateProviderAccountDefaultForOperationsCopier;
import software.amazon.awssdk.services.iot.model.CertificateProviderOperation;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCertificateProviderRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateCertificateProviderRequest> {
    private static final SdkField<String> CERTIFICATE_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateProviderName").getter(UpdateCertificateProviderRequest.getter(UpdateCertificateProviderRequest::certificateProviderName)).setter(UpdateCertificateProviderRequest.setter(Builder::certificateProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("certificateProviderName").build()}).build();
    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambdaFunctionArn").getter(UpdateCertificateProviderRequest.getter(UpdateCertificateProviderRequest::lambdaFunctionArn)).setter(UpdateCertificateProviderRequest.setter(Builder::lambdaFunctionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionArn").build()}).build();
    private static final SdkField<List<String>> ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountDefaultForOperations").getter(UpdateCertificateProviderRequest.getter(UpdateCertificateProviderRequest::accountDefaultForOperationsAsStrings)).setter(UpdateCertificateProviderRequest.setter(Builder::accountDefaultForOperationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountDefaultForOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_PROVIDER_NAME_FIELD, LAMBDA_FUNCTION_ARN_FIELD, ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("certificateProviderName", CERTIFICATE_PROVIDER_NAME_FIELD);
            this.put("lambdaFunctionArn", LAMBDA_FUNCTION_ARN_FIELD);
            this.put("accountDefaultForOperations", ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD);
        }
    });
    private final String certificateProviderName;
    private final String lambdaFunctionArn;
    private final List<String> accountDefaultForOperations;

    private UpdateCertificateProviderRequest(BuilderImpl builder) {
        super(builder);
        this.certificateProviderName = builder.certificateProviderName;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
        this.accountDefaultForOperations = builder.accountDefaultForOperations;
    }

    public final String certificateProviderName() {
        return this.certificateProviderName;
    }

    public final String lambdaFunctionArn() {
        return this.lambdaFunctionArn;
    }

    public final List<CertificateProviderOperation> accountDefaultForOperations() {
        return CertificateProviderAccountDefaultForOperationsCopier.copyStringToEnum(this.accountDefaultForOperations);
    }

    public final boolean hasAccountDefaultForOperations() {
        return this.accountDefaultForOperations != null && !(this.accountDefaultForOperations instanceof SdkAutoConstructList);
    }

    public final List<String> accountDefaultForOperationsAsStrings() {
        return this.accountDefaultForOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountDefaultForOperations() ? this.accountDefaultForOperationsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCertificateProviderRequest)) {
            return false;
        }
        UpdateCertificateProviderRequest other = (UpdateCertificateProviderRequest)((Object)obj);
        return Objects.equals(this.certificateProviderName(), other.certificateProviderName()) && Objects.equals(this.lambdaFunctionArn(), other.lambdaFunctionArn()) && this.hasAccountDefaultForOperations() == other.hasAccountDefaultForOperations() && Objects.equals(this.accountDefaultForOperationsAsStrings(), other.accountDefaultForOperationsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCertificateProviderRequest").add("CertificateProviderName", (Object)this.certificateProviderName()).add("LambdaFunctionArn", (Object)this.lambdaFunctionArn()).add("AccountDefaultForOperations", this.hasAccountDefaultForOperations() ? this.accountDefaultForOperationsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateProviderName": {
                return Optional.ofNullable(clazz.cast(this.certificateProviderName()));
            }
            case "lambdaFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionArn()));
            }
            case "accountDefaultForOperations": {
                return Optional.ofNullable(clazz.cast(this.accountDefaultForOperationsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCertificateProviderRequest, T> g) {
        return obj -> g.apply((UpdateCertificateProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String certificateProviderName;
        private String lambdaFunctionArn;
        private List<String> accountDefaultForOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCertificateProviderRequest model) {
            super(model);
            this.certificateProviderName(model.certificateProviderName);
            this.lambdaFunctionArn(model.lambdaFunctionArn);
            this.accountDefaultForOperationsWithStrings(model.accountDefaultForOperations);
        }

        public final String getCertificateProviderName() {
            return this.certificateProviderName;
        }

        public final void setCertificateProviderName(String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
        }

        @Override
        public final Builder certificateProviderName(String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
            return this;
        }

        public final String getLambdaFunctionArn() {
            return this.lambdaFunctionArn;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        public final Collection<String> getAccountDefaultForOperations() {
            if (this.accountDefaultForOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountDefaultForOperations;
        }

        public final void setAccountDefaultForOperations(Collection<String> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier.copy(accountDefaultForOperations);
        }

        @Override
        public final Builder accountDefaultForOperationsWithStrings(Collection<String> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier.copy(accountDefaultForOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDefaultForOperationsWithStrings(String ... accountDefaultForOperations) {
            this.accountDefaultForOperationsWithStrings(Arrays.asList(accountDefaultForOperations));
            return this;
        }

        @Override
        public final Builder accountDefaultForOperations(Collection<CertificateProviderOperation> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier.copyEnumToString(accountDefaultForOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDefaultForOperations(CertificateProviderOperation ... accountDefaultForOperations) {
            this.accountDefaultForOperations(Arrays.asList(accountDefaultForOperations));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCertificateProviderRequest build() {
            return new UpdateCertificateProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCertificateProviderRequest> {
        public Builder certificateProviderName(String var1);

        public Builder lambdaFunctionArn(String var1);

        public Builder accountDefaultForOperationsWithStrings(Collection<String> var1);

        public Builder accountDefaultForOperationsWithStrings(String ... var1);

        public Builder accountDefaultForOperations(Collection<CertificateProviderOperation> var1);

        public Builder accountDefaultForOperations(CertificateProviderOperation ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

