/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.RetryableFailureType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetryCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetryCriteria> {
    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureType").getter(RetryCriteria.getter(RetryCriteria::failureTypeAsString)).setter(RetryCriteria.setter(Builder::failureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureType").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfRetries").getter(RetryCriteria.getter(RetryCriteria::numberOfRetries)).setter(RetryCriteria.setter(Builder::numberOfRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRetries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_TYPE_FIELD, NUMBER_OF_RETRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("failureType", FAILURE_TYPE_FIELD);
            this.put("numberOfRetries", NUMBER_OF_RETRIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String failureType;
    private final Integer numberOfRetries;

    private RetryCriteria(BuilderImpl builder) {
        this.failureType = builder.failureType;
        this.numberOfRetries = builder.numberOfRetries;
    }

    public final RetryableFailureType failureType() {
        return RetryableFailureType.fromValue(this.failureType);
    }

    public final String failureTypeAsString() {
        return this.failureType;
    }

    public final Integer numberOfRetries() {
        return this.numberOfRetries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRetries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryCriteria)) {
            return false;
        }
        RetryCriteria other = (RetryCriteria)obj;
        return Objects.equals(this.failureTypeAsString(), other.failureTypeAsString()) && Objects.equals(this.numberOfRetries(), other.numberOfRetries());
    }

    public final String toString() {
        return ToString.builder((String)"RetryCriteria").add("FailureType", (Object)this.failureTypeAsString()).add("NumberOfRetries", (Object)this.numberOfRetries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failureType": {
                return Optional.ofNullable(clazz.cast(this.failureTypeAsString()));
            }
            case "numberOfRetries": {
                return Optional.ofNullable(clazz.cast(this.numberOfRetries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RetryCriteria, T> g) {
        return obj -> g.apply((RetryCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failureType;
        private Integer numberOfRetries;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryCriteria model) {
            this.failureType(model.failureType);
            this.numberOfRetries(model.numberOfRetries);
        }

        public final String getFailureType() {
            return this.failureType;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(RetryableFailureType failureType) {
            this.failureType(failureType == null ? null : failureType.toString());
            return this;
        }

        public final Integer getNumberOfRetries() {
            return this.numberOfRetries;
        }

        public final void setNumberOfRetries(Integer numberOfRetries) {
            this.numberOfRetries = numberOfRetries;
        }

        @Override
        public final Builder numberOfRetries(Integer numberOfRetries) {
            this.numberOfRetries = numberOfRetries;
            return this;
        }

        public RetryCriteria build() {
            return new RetryCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetryCriteria> {
        public Builder failureType(String var1);

        public Builder failureType(RetryableFailureType var1);

        public Builder numberOfRetries(Integer var1);
    }
}

