/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.ThingPrincipalType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrincipalThingObject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrincipalThingObject> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(PrincipalThingObject.getter(PrincipalThingObject::thingName)).setter(PrincipalThingObject.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<String> THING_PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingPrincipalType").getter(PrincipalThingObject.getter(PrincipalThingObject::thingPrincipalTypeAsString)).setter(PrincipalThingObject.setter(Builder::thingPrincipalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingPrincipalType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, THING_PRINCIPAL_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("thingName", THING_NAME_FIELD);
            this.put("thingPrincipalType", THING_PRINCIPAL_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String thingName;
    private final String thingPrincipalType;

    private PrincipalThingObject(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.thingPrincipalType = builder.thingPrincipalType;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final ThingPrincipalType thingPrincipalType() {
        return ThingPrincipalType.fromValue(this.thingPrincipalType);
    }

    public final String thingPrincipalTypeAsString() {
        return this.thingPrincipalType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingPrincipalTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalThingObject)) {
            return false;
        }
        PrincipalThingObject other = (PrincipalThingObject)obj;
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingPrincipalTypeAsString(), other.thingPrincipalTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PrincipalThingObject").add("ThingName", (Object)this.thingName()).add("ThingPrincipalType", (Object)this.thingPrincipalTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "thingPrincipalType": {
                return Optional.ofNullable(clazz.cast(this.thingPrincipalTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PrincipalThingObject, T> g) {
        return obj -> g.apply((PrincipalThingObject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingName;
        private String thingPrincipalType;

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalThingObject model) {
            this.thingName(model.thingName);
            this.thingPrincipalType(model.thingPrincipalType);
        }

        public final String getThingName() {
            return this.thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getThingPrincipalType() {
            return this.thingPrincipalType;
        }

        public final void setThingPrincipalType(String thingPrincipalType) {
            this.thingPrincipalType = thingPrincipalType;
        }

        @Override
        public final Builder thingPrincipalType(String thingPrincipalType) {
            this.thingPrincipalType = thingPrincipalType;
            return this;
        }

        @Override
        public final Builder thingPrincipalType(ThingPrincipalType thingPrincipalType) {
            this.thingPrincipalType(thingPrincipalType == null ? null : thingPrincipalType.toString());
            return this;
        }

        public PrincipalThingObject build() {
            return new PrincipalThingObject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrincipalThingObject> {
        public Builder thingName(String var1);

        public Builder thingPrincipalType(String var1);

        public Builder thingPrincipalType(ThingPrincipalType var1);
    }
}

