/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.CloudwatchAlarmAction;
import software.amazon.awssdk.services.iot.model.CloudwatchLogsAction;
import software.amazon.awssdk.services.iot.model.CloudwatchMetricAction;
import software.amazon.awssdk.services.iot.model.DynamoDBAction;
import software.amazon.awssdk.services.iot.model.DynamoDBv2Action;
import software.amazon.awssdk.services.iot.model.ElasticsearchAction;
import software.amazon.awssdk.services.iot.model.FirehoseAction;
import software.amazon.awssdk.services.iot.model.HttpAction;
import software.amazon.awssdk.services.iot.model.IotAnalyticsAction;
import software.amazon.awssdk.services.iot.model.IotEventsAction;
import software.amazon.awssdk.services.iot.model.IotSiteWiseAction;
import software.amazon.awssdk.services.iot.model.KafkaAction;
import software.amazon.awssdk.services.iot.model.KinesisAction;
import software.amazon.awssdk.services.iot.model.LambdaAction;
import software.amazon.awssdk.services.iot.model.LocationAction;
import software.amazon.awssdk.services.iot.model.OpenSearchAction;
import software.amazon.awssdk.services.iot.model.RepublishAction;
import software.amazon.awssdk.services.iot.model.S3Action;
import software.amazon.awssdk.services.iot.model.SalesforceAction;
import software.amazon.awssdk.services.iot.model.SnsAction;
import software.amazon.awssdk.services.iot.model.SqsAction;
import software.amazon.awssdk.services.iot.model.StepFunctionsAction;
import software.amazon.awssdk.services.iot.model.TimestreamAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Action
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Action> {
    private static final SdkField<DynamoDBAction> DYNAMO_DB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dynamoDB").getter(Action.getter(Action::dynamoDB)).setter(Action.setter(Builder::dynamoDB)).constructor(DynamoDBAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamoDB").build()}).build();
    private static final SdkField<DynamoDBv2Action> DYNAMO_DB_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dynamoDBv2").getter(Action.getter(Action::dynamoDBv2)).setter(Action.setter(Builder::dynamoDBv2)).constructor(DynamoDBv2Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamoDBv2").build()}).build();
    private static final SdkField<LambdaAction> LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambda").getter(Action.getter(Action::lambda)).setter(Action.setter(Builder::lambda)).constructor(LambdaAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()}).build();
    private static final SdkField<SnsAction> SNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sns").getter(Action.getter(Action::sns)).setter(Action.setter(Builder::sns)).constructor(SnsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sns").build()}).build();
    private static final SdkField<SqsAction> SQS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sqs").getter(Action.getter(Action::sqs)).setter(Action.setter(Builder::sqs)).constructor(SqsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqs").build()}).build();
    private static final SdkField<KinesisAction> KINESIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kinesis").getter(Action.getter(Action::kinesis)).setter(Action.setter(Builder::kinesis)).constructor(KinesisAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kinesis").build()}).build();
    private static final SdkField<RepublishAction> REPUBLISH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("republish").getter(Action.getter(Action::republish)).setter(Action.setter(Builder::republish)).constructor(RepublishAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("republish").build()}).build();
    private static final SdkField<S3Action> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(Action.getter(Action::s3)).setter(Action.setter(Builder::s3)).constructor(S3Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final SdkField<FirehoseAction> FIREHOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("firehose").getter(Action.getter(Action::firehose)).setter(Action.setter(Builder::firehose)).constructor(FirehoseAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()}).build();
    private static final SdkField<CloudwatchMetricAction> CLOUDWATCH_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudwatchMetric").getter(Action.getter(Action::cloudwatchMetric)).setter(Action.setter(Builder::cloudwatchMetric)).constructor(CloudwatchMetricAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudwatchMetric").build()}).build();
    private static final SdkField<CloudwatchAlarmAction> CLOUDWATCH_ALARM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudwatchAlarm").getter(Action.getter(Action::cloudwatchAlarm)).setter(Action.setter(Builder::cloudwatchAlarm)).constructor(CloudwatchAlarmAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudwatchAlarm").build()}).build();
    private static final SdkField<CloudwatchLogsAction> CLOUDWATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudwatchLogs").getter(Action.getter(Action::cloudwatchLogs)).setter(Action.setter(Builder::cloudwatchLogs)).constructor(CloudwatchLogsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudwatchLogs").build()}).build();
    private static final SdkField<ElasticsearchAction> ELASTICSEARCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("elasticsearch").getter(Action.getter(Action::elasticsearch)).setter(Action.setter(Builder::elasticsearch)).constructor(ElasticsearchAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elasticsearch").build()}).build();
    private static final SdkField<SalesforceAction> SALESFORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("salesforce").getter(Action.getter(Action::salesforce)).setter(Action.setter(Builder::salesforce)).constructor(SalesforceAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("salesforce").build()}).build();
    private static final SdkField<IotAnalyticsAction> IOT_ANALYTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotAnalytics").getter(Action.getter(Action::iotAnalytics)).setter(Action.setter(Builder::iotAnalytics)).constructor(IotAnalyticsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotAnalytics").build()}).build();
    private static final SdkField<IotEventsAction> IOT_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotEvents").getter(Action.getter(Action::iotEvents)).setter(Action.setter(Builder::iotEvents)).constructor(IotEventsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotEvents").build()}).build();
    private static final SdkField<IotSiteWiseAction> IOT_SITE_WISE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotSiteWise").getter(Action.getter(Action::iotSiteWise)).setter(Action.setter(Builder::iotSiteWise)).constructor(IotSiteWiseAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotSiteWise").build()}).build();
    private static final SdkField<StepFunctionsAction> STEP_FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stepFunctions").getter(Action.getter(Action::stepFunctions)).setter(Action.setter(Builder::stepFunctions)).constructor(StepFunctionsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepFunctions").build()}).build();
    private static final SdkField<TimestreamAction> TIMESTREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timestream").getter(Action.getter(Action::timestream)).setter(Action.setter(Builder::timestream)).constructor(TimestreamAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestream").build()}).build();
    private static final SdkField<HttpAction> HTTP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("http").getter(Action.getter(Action::http)).setter(Action.setter(Builder::http)).constructor(HttpAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http").build()}).build();
    private static final SdkField<KafkaAction> KAFKA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kafka").getter(Action.getter(Action::kafka)).setter(Action.setter(Builder::kafka)).constructor(KafkaAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafka").build()}).build();
    private static final SdkField<OpenSearchAction> OPEN_SEARCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openSearch").getter(Action.getter(Action::openSearch)).setter(Action.setter(Builder::openSearch)).constructor(OpenSearchAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openSearch").build()}).build();
    private static final SdkField<LocationAction> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(Action.getter(Action::location)).setter(Action.setter(Builder::location)).constructor(LocationAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMO_DB_FIELD, DYNAMO_DB_V2_FIELD, LAMBDA_FIELD, SNS_FIELD, SQS_FIELD, KINESIS_FIELD, REPUBLISH_FIELD, S3_FIELD, FIREHOSE_FIELD, CLOUDWATCH_METRIC_FIELD, CLOUDWATCH_ALARM_FIELD, CLOUDWATCH_LOGS_FIELD, ELASTICSEARCH_FIELD, SALESFORCE_FIELD, IOT_ANALYTICS_FIELD, IOT_EVENTS_FIELD, IOT_SITE_WISE_FIELD, STEP_FUNCTIONS_FIELD, TIMESTREAM_FIELD, HTTP_FIELD, KAFKA_FIELD, OPEN_SEARCH_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("dynamoDB", DYNAMO_DB_FIELD);
            this.put("dynamoDBv2", DYNAMO_DB_V2_FIELD);
            this.put("lambda", LAMBDA_FIELD);
            this.put("sns", SNS_FIELD);
            this.put("sqs", SQS_FIELD);
            this.put("kinesis", KINESIS_FIELD);
            this.put("republish", REPUBLISH_FIELD);
            this.put("s3", S3_FIELD);
            this.put("firehose", FIREHOSE_FIELD);
            this.put("cloudwatchMetric", CLOUDWATCH_METRIC_FIELD);
            this.put("cloudwatchAlarm", CLOUDWATCH_ALARM_FIELD);
            this.put("cloudwatchLogs", CLOUDWATCH_LOGS_FIELD);
            this.put("elasticsearch", ELASTICSEARCH_FIELD);
            this.put("salesforce", SALESFORCE_FIELD);
            this.put("iotAnalytics", IOT_ANALYTICS_FIELD);
            this.put("iotEvents", IOT_EVENTS_FIELD);
            this.put("iotSiteWise", IOT_SITE_WISE_FIELD);
            this.put("stepFunctions", STEP_FUNCTIONS_FIELD);
            this.put("timestream", TIMESTREAM_FIELD);
            this.put("http", HTTP_FIELD);
            this.put("kafka", KAFKA_FIELD);
            this.put("openSearch", OPEN_SEARCH_FIELD);
            this.put("location", LOCATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final DynamoDBAction dynamoDB;
    private final DynamoDBv2Action dynamoDBv2;
    private final LambdaAction lambda;
    private final SnsAction sns;
    private final SqsAction sqs;
    private final KinesisAction kinesis;
    private final RepublishAction republish;
    private final S3Action s3;
    private final FirehoseAction firehose;
    private final CloudwatchMetricAction cloudwatchMetric;
    private final CloudwatchAlarmAction cloudwatchAlarm;
    private final CloudwatchLogsAction cloudwatchLogs;
    private final ElasticsearchAction elasticsearch;
    private final SalesforceAction salesforce;
    private final IotAnalyticsAction iotAnalytics;
    private final IotEventsAction iotEvents;
    private final IotSiteWiseAction iotSiteWise;
    private final StepFunctionsAction stepFunctions;
    private final TimestreamAction timestream;
    private final HttpAction http;
    private final KafkaAction kafka;
    private final OpenSearchAction openSearch;
    private final LocationAction location;

    private Action(BuilderImpl builder) {
        this.dynamoDB = builder.dynamoDB;
        this.dynamoDBv2 = builder.dynamoDBv2;
        this.lambda = builder.lambda;
        this.sns = builder.sns;
        this.sqs = builder.sqs;
        this.kinesis = builder.kinesis;
        this.republish = builder.republish;
        this.s3 = builder.s3;
        this.firehose = builder.firehose;
        this.cloudwatchMetric = builder.cloudwatchMetric;
        this.cloudwatchAlarm = builder.cloudwatchAlarm;
        this.cloudwatchLogs = builder.cloudwatchLogs;
        this.elasticsearch = builder.elasticsearch;
        this.salesforce = builder.salesforce;
        this.iotAnalytics = builder.iotAnalytics;
        this.iotEvents = builder.iotEvents;
        this.iotSiteWise = builder.iotSiteWise;
        this.stepFunctions = builder.stepFunctions;
        this.timestream = builder.timestream;
        this.http = builder.http;
        this.kafka = builder.kafka;
        this.openSearch = builder.openSearch;
        this.location = builder.location;
    }

    public final DynamoDBAction dynamoDB() {
        return this.dynamoDB;
    }

    public final DynamoDBv2Action dynamoDBv2() {
        return this.dynamoDBv2;
    }

    public final LambdaAction lambda() {
        return this.lambda;
    }

    public final SnsAction sns() {
        return this.sns;
    }

    public final SqsAction sqs() {
        return this.sqs;
    }

    public final KinesisAction kinesis() {
        return this.kinesis;
    }

    public final RepublishAction republish() {
        return this.republish;
    }

    public final S3Action s3() {
        return this.s3;
    }

    public final FirehoseAction firehose() {
        return this.firehose;
    }

    public final CloudwatchMetricAction cloudwatchMetric() {
        return this.cloudwatchMetric;
    }

    public final CloudwatchAlarmAction cloudwatchAlarm() {
        return this.cloudwatchAlarm;
    }

    public final CloudwatchLogsAction cloudwatchLogs() {
        return this.cloudwatchLogs;
    }

    public final ElasticsearchAction elasticsearch() {
        return this.elasticsearch;
    }

    public final SalesforceAction salesforce() {
        return this.salesforce;
    }

    public final IotAnalyticsAction iotAnalytics() {
        return this.iotAnalytics;
    }

    public final IotEventsAction iotEvents() {
        return this.iotEvents;
    }

    public final IotSiteWiseAction iotSiteWise() {
        return this.iotSiteWise;
    }

    public final StepFunctionsAction stepFunctions() {
        return this.stepFunctions;
    }

    public final TimestreamAction timestream() {
        return this.timestream;
    }

    public final HttpAction http() {
        return this.http;
    }

    public final KafkaAction kafka() {
        return this.kafka;
    }

    public final OpenSearchAction openSearch() {
        return this.openSearch;
    }

    public final LocationAction location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDB());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDBv2());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambda());
        hashCode = 31 * hashCode + Objects.hashCode(this.sns());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqs());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesis());
        hashCode = 31 * hashCode + Objects.hashCode(this.republish());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehose());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchMetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearch());
        hashCode = 31 * hashCode + Objects.hashCode(this.salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotAnalytics());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotSiteWise());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepFunctions());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestream());
        hashCode = 31 * hashCode + Objects.hashCode(this.http());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafka());
        hashCode = 31 * hashCode + Objects.hashCode(this.openSearch());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.dynamoDB(), other.dynamoDB()) && Objects.equals(this.dynamoDBv2(), other.dynamoDBv2()) && Objects.equals(this.lambda(), other.lambda()) && Objects.equals(this.sns(), other.sns()) && Objects.equals(this.sqs(), other.sqs()) && Objects.equals(this.kinesis(), other.kinesis()) && Objects.equals(this.republish(), other.republish()) && Objects.equals(this.s3(), other.s3()) && Objects.equals(this.firehose(), other.firehose()) && Objects.equals(this.cloudwatchMetric(), other.cloudwatchMetric()) && Objects.equals(this.cloudwatchAlarm(), other.cloudwatchAlarm()) && Objects.equals(this.cloudwatchLogs(), other.cloudwatchLogs()) && Objects.equals(this.elasticsearch(), other.elasticsearch()) && Objects.equals(this.salesforce(), other.salesforce()) && Objects.equals(this.iotAnalytics(), other.iotAnalytics()) && Objects.equals(this.iotEvents(), other.iotEvents()) && Objects.equals(this.iotSiteWise(), other.iotSiteWise()) && Objects.equals(this.stepFunctions(), other.stepFunctions()) && Objects.equals(this.timestream(), other.timestream()) && Objects.equals(this.http(), other.http()) && Objects.equals(this.kafka(), other.kafka()) && Objects.equals(this.openSearch(), other.openSearch()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"Action").add("DynamoDB", (Object)this.dynamoDB()).add("DynamoDBv2", (Object)this.dynamoDBv2()).add("Lambda", (Object)this.lambda()).add("Sns", (Object)this.sns()).add("Sqs", (Object)this.sqs()).add("Kinesis", (Object)this.kinesis()).add("Republish", (Object)this.republish()).add("S3", (Object)this.s3()).add("Firehose", (Object)this.firehose()).add("CloudwatchMetric", (Object)this.cloudwatchMetric()).add("CloudwatchAlarm", (Object)this.cloudwatchAlarm()).add("CloudwatchLogs", (Object)this.cloudwatchLogs()).add("Elasticsearch", (Object)this.elasticsearch()).add("Salesforce", (Object)this.salesforce()).add("IotAnalytics", (Object)this.iotAnalytics()).add("IotEvents", (Object)this.iotEvents()).add("IotSiteWise", (Object)this.iotSiteWise()).add("StepFunctions", (Object)this.stepFunctions()).add("Timestream", (Object)this.timestream()).add("Http", (Object)this.http()).add("Kafka", (Object)this.kafka()).add("OpenSearch", (Object)this.openSearch()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dynamoDB": {
                return Optional.ofNullable(clazz.cast(this.dynamoDB()));
            }
            case "dynamoDBv2": {
                return Optional.ofNullable(clazz.cast(this.dynamoDBv2()));
            }
            case "lambda": {
                return Optional.ofNullable(clazz.cast(this.lambda()));
            }
            case "sns": {
                return Optional.ofNullable(clazz.cast(this.sns()));
            }
            case "sqs": {
                return Optional.ofNullable(clazz.cast(this.sqs()));
            }
            case "kinesis": {
                return Optional.ofNullable(clazz.cast(this.kinesis()));
            }
            case "republish": {
                return Optional.ofNullable(clazz.cast(this.republish()));
            }
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "firehose": {
                return Optional.ofNullable(clazz.cast(this.firehose()));
            }
            case "cloudwatchMetric": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchMetric()));
            }
            case "cloudwatchAlarm": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchAlarm()));
            }
            case "cloudwatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchLogs()));
            }
            case "elasticsearch": {
                return Optional.ofNullable(clazz.cast(this.elasticsearch()));
            }
            case "salesforce": {
                return Optional.ofNullable(clazz.cast(this.salesforce()));
            }
            case "iotAnalytics": {
                return Optional.ofNullable(clazz.cast(this.iotAnalytics()));
            }
            case "iotEvents": {
                return Optional.ofNullable(clazz.cast(this.iotEvents()));
            }
            case "iotSiteWise": {
                return Optional.ofNullable(clazz.cast(this.iotSiteWise()));
            }
            case "stepFunctions": {
                return Optional.ofNullable(clazz.cast(this.stepFunctions()));
            }
            case "timestream": {
                return Optional.ofNullable(clazz.cast(this.timestream()));
            }
            case "http": {
                return Optional.ofNullable(clazz.cast(this.http()));
            }
            case "kafka": {
                return Optional.ofNullable(clazz.cast(this.kafka()));
            }
            case "openSearch": {
                return Optional.ofNullable(clazz.cast(this.openSearch()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DynamoDBAction dynamoDB;
        private DynamoDBv2Action dynamoDBv2;
        private LambdaAction lambda;
        private SnsAction sns;
        private SqsAction sqs;
        private KinesisAction kinesis;
        private RepublishAction republish;
        private S3Action s3;
        private FirehoseAction firehose;
        private CloudwatchMetricAction cloudwatchMetric;
        private CloudwatchAlarmAction cloudwatchAlarm;
        private CloudwatchLogsAction cloudwatchLogs;
        private ElasticsearchAction elasticsearch;
        private SalesforceAction salesforce;
        private IotAnalyticsAction iotAnalytics;
        private IotEventsAction iotEvents;
        private IotSiteWiseAction iotSiteWise;
        private StepFunctionsAction stepFunctions;
        private TimestreamAction timestream;
        private HttpAction http;
        private KafkaAction kafka;
        private OpenSearchAction openSearch;
        private LocationAction location;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.dynamoDB(model.dynamoDB);
            this.dynamoDBv2(model.dynamoDBv2);
            this.lambda(model.lambda);
            this.sns(model.sns);
            this.sqs(model.sqs);
            this.kinesis(model.kinesis);
            this.republish(model.republish);
            this.s3(model.s3);
            this.firehose(model.firehose);
            this.cloudwatchMetric(model.cloudwatchMetric);
            this.cloudwatchAlarm(model.cloudwatchAlarm);
            this.cloudwatchLogs(model.cloudwatchLogs);
            this.elasticsearch(model.elasticsearch);
            this.salesforce(model.salesforce);
            this.iotAnalytics(model.iotAnalytics);
            this.iotEvents(model.iotEvents);
            this.iotSiteWise(model.iotSiteWise);
            this.stepFunctions(model.stepFunctions);
            this.timestream(model.timestream);
            this.http(model.http);
            this.kafka(model.kafka);
            this.openSearch(model.openSearch);
            this.location(model.location);
        }

        public final DynamoDBAction.Builder getDynamoDB() {
            return this.dynamoDB != null ? this.dynamoDB.toBuilder() : null;
        }

        public final void setDynamoDB(DynamoDBAction.BuilderImpl dynamoDB) {
            this.dynamoDB = dynamoDB != null ? dynamoDB.build() : null;
        }

        @Override
        public final Builder dynamoDB(DynamoDBAction dynamoDB) {
            this.dynamoDB = dynamoDB;
            return this;
        }

        public final DynamoDBv2Action.Builder getDynamoDBv2() {
            return this.dynamoDBv2 != null ? this.dynamoDBv2.toBuilder() : null;
        }

        public final void setDynamoDBv2(DynamoDBv2Action.BuilderImpl dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2 != null ? dynamoDBv2.build() : null;
        }

        @Override
        public final Builder dynamoDBv2(DynamoDBv2Action dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2;
            return this;
        }

        public final LambdaAction.Builder getLambda() {
            return this.lambda != null ? this.lambda.toBuilder() : null;
        }

        public final void setLambda(LambdaAction.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public final Builder lambda(LambdaAction lambda) {
            this.lambda = lambda;
            return this;
        }

        public final SnsAction.Builder getSns() {
            return this.sns != null ? this.sns.toBuilder() : null;
        }

        public final void setSns(SnsAction.BuilderImpl sns) {
            this.sns = sns != null ? sns.build() : null;
        }

        @Override
        public final Builder sns(SnsAction sns) {
            this.sns = sns;
            return this;
        }

        public final SqsAction.Builder getSqs() {
            return this.sqs != null ? this.sqs.toBuilder() : null;
        }

        public final void setSqs(SqsAction.BuilderImpl sqs) {
            this.sqs = sqs != null ? sqs.build() : null;
        }

        @Override
        public final Builder sqs(SqsAction sqs) {
            this.sqs = sqs;
            return this;
        }

        public final KinesisAction.Builder getKinesis() {
            return this.kinesis != null ? this.kinesis.toBuilder() : null;
        }

        public final void setKinesis(KinesisAction.BuilderImpl kinesis) {
            this.kinesis = kinesis != null ? kinesis.build() : null;
        }

        @Override
        public final Builder kinesis(KinesisAction kinesis) {
            this.kinesis = kinesis;
            return this;
        }

        public final RepublishAction.Builder getRepublish() {
            return this.republish != null ? this.republish.toBuilder() : null;
        }

        public final void setRepublish(RepublishAction.BuilderImpl republish) {
            this.republish = republish != null ? republish.build() : null;
        }

        @Override
        public final Builder republish(RepublishAction republish) {
            this.republish = republish;
            return this;
        }

        public final S3Action.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3Action.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3Action s3) {
            this.s3 = s3;
            return this;
        }

        public final FirehoseAction.Builder getFirehose() {
            return this.firehose != null ? this.firehose.toBuilder() : null;
        }

        public final void setFirehose(FirehoseAction.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        @Override
        public final Builder firehose(FirehoseAction firehose) {
            this.firehose = firehose;
            return this;
        }

        public final CloudwatchMetricAction.Builder getCloudwatchMetric() {
            return this.cloudwatchMetric != null ? this.cloudwatchMetric.toBuilder() : null;
        }

        public final void setCloudwatchMetric(CloudwatchMetricAction.BuilderImpl cloudwatchMetric) {
            this.cloudwatchMetric = cloudwatchMetric != null ? cloudwatchMetric.build() : null;
        }

        @Override
        public final Builder cloudwatchMetric(CloudwatchMetricAction cloudwatchMetric) {
            this.cloudwatchMetric = cloudwatchMetric;
            return this;
        }

        public final CloudwatchAlarmAction.Builder getCloudwatchAlarm() {
            return this.cloudwatchAlarm != null ? this.cloudwatchAlarm.toBuilder() : null;
        }

        public final void setCloudwatchAlarm(CloudwatchAlarmAction.BuilderImpl cloudwatchAlarm) {
            this.cloudwatchAlarm = cloudwatchAlarm != null ? cloudwatchAlarm.build() : null;
        }

        @Override
        public final Builder cloudwatchAlarm(CloudwatchAlarmAction cloudwatchAlarm) {
            this.cloudwatchAlarm = cloudwatchAlarm;
            return this;
        }

        public final CloudwatchLogsAction.Builder getCloudwatchLogs() {
            return this.cloudwatchLogs != null ? this.cloudwatchLogs.toBuilder() : null;
        }

        public final void setCloudwatchLogs(CloudwatchLogsAction.BuilderImpl cloudwatchLogs) {
            this.cloudwatchLogs = cloudwatchLogs != null ? cloudwatchLogs.build() : null;
        }

        @Override
        public final Builder cloudwatchLogs(CloudwatchLogsAction cloudwatchLogs) {
            this.cloudwatchLogs = cloudwatchLogs;
            return this;
        }

        public final ElasticsearchAction.Builder getElasticsearch() {
            return this.elasticsearch != null ? this.elasticsearch.toBuilder() : null;
        }

        public final void setElasticsearch(ElasticsearchAction.BuilderImpl elasticsearch) {
            this.elasticsearch = elasticsearch != null ? elasticsearch.build() : null;
        }

        @Override
        public final Builder elasticsearch(ElasticsearchAction elasticsearch) {
            this.elasticsearch = elasticsearch;
            return this;
        }

        public final SalesforceAction.Builder getSalesforce() {
            return this.salesforce != null ? this.salesforce.toBuilder() : null;
        }

        public final void setSalesforce(SalesforceAction.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        @Override
        public final Builder salesforce(SalesforceAction salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final IotAnalyticsAction.Builder getIotAnalytics() {
            return this.iotAnalytics != null ? this.iotAnalytics.toBuilder() : null;
        }

        public final void setIotAnalytics(IotAnalyticsAction.BuilderImpl iotAnalytics) {
            this.iotAnalytics = iotAnalytics != null ? iotAnalytics.build() : null;
        }

        @Override
        public final Builder iotAnalytics(IotAnalyticsAction iotAnalytics) {
            this.iotAnalytics = iotAnalytics;
            return this;
        }

        public final IotEventsAction.Builder getIotEvents() {
            return this.iotEvents != null ? this.iotEvents.toBuilder() : null;
        }

        public final void setIotEvents(IotEventsAction.BuilderImpl iotEvents) {
            this.iotEvents = iotEvents != null ? iotEvents.build() : null;
        }

        @Override
        public final Builder iotEvents(IotEventsAction iotEvents) {
            this.iotEvents = iotEvents;
            return this;
        }

        public final IotSiteWiseAction.Builder getIotSiteWise() {
            return this.iotSiteWise != null ? this.iotSiteWise.toBuilder() : null;
        }

        public final void setIotSiteWise(IotSiteWiseAction.BuilderImpl iotSiteWise) {
            this.iotSiteWise = iotSiteWise != null ? iotSiteWise.build() : null;
        }

        @Override
        public final Builder iotSiteWise(IotSiteWiseAction iotSiteWise) {
            this.iotSiteWise = iotSiteWise;
            return this;
        }

        public final StepFunctionsAction.Builder getStepFunctions() {
            return this.stepFunctions != null ? this.stepFunctions.toBuilder() : null;
        }

        public final void setStepFunctions(StepFunctionsAction.BuilderImpl stepFunctions) {
            this.stepFunctions = stepFunctions != null ? stepFunctions.build() : null;
        }

        @Override
        public final Builder stepFunctions(StepFunctionsAction stepFunctions) {
            this.stepFunctions = stepFunctions;
            return this;
        }

        public final TimestreamAction.Builder getTimestream() {
            return this.timestream != null ? this.timestream.toBuilder() : null;
        }

        public final void setTimestream(TimestreamAction.BuilderImpl timestream) {
            this.timestream = timestream != null ? timestream.build() : null;
        }

        @Override
        public final Builder timestream(TimestreamAction timestream) {
            this.timestream = timestream;
            return this;
        }

        public final HttpAction.Builder getHttp() {
            return this.http != null ? this.http.toBuilder() : null;
        }

        public final void setHttp(HttpAction.BuilderImpl http) {
            this.http = http != null ? http.build() : null;
        }

        @Override
        public final Builder http(HttpAction http) {
            this.http = http;
            return this;
        }

        public final KafkaAction.Builder getKafka() {
            return this.kafka != null ? this.kafka.toBuilder() : null;
        }

        public final void setKafka(KafkaAction.BuilderImpl kafka) {
            this.kafka = kafka != null ? kafka.build() : null;
        }

        @Override
        public final Builder kafka(KafkaAction kafka) {
            this.kafka = kafka;
            return this;
        }

        public final OpenSearchAction.Builder getOpenSearch() {
            return this.openSearch != null ? this.openSearch.toBuilder() : null;
        }

        public final void setOpenSearch(OpenSearchAction.BuilderImpl openSearch) {
            this.openSearch = openSearch != null ? openSearch.build() : null;
        }

        @Override
        public final Builder openSearch(OpenSearchAction openSearch) {
            this.openSearch = openSearch;
            return this;
        }

        public final LocationAction.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(LocationAction.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(LocationAction location) {
            this.location = location;
            return this;
        }

        public Action build() {
            return new Action(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Action> {
        public Builder dynamoDB(DynamoDBAction var1);

        default public Builder dynamoDB(Consumer<DynamoDBAction.Builder> dynamoDB) {
            return this.dynamoDB((DynamoDBAction)((DynamoDBAction.Builder)DynamoDBAction.builder().applyMutation(dynamoDB)).build());
        }

        public Builder dynamoDBv2(DynamoDBv2Action var1);

        default public Builder dynamoDBv2(Consumer<DynamoDBv2Action.Builder> dynamoDBv2) {
            return this.dynamoDBv2((DynamoDBv2Action)((DynamoDBv2Action.Builder)DynamoDBv2Action.builder().applyMutation(dynamoDBv2)).build());
        }

        public Builder lambda(LambdaAction var1);

        default public Builder lambda(Consumer<LambdaAction.Builder> lambda) {
            return this.lambda((LambdaAction)((LambdaAction.Builder)LambdaAction.builder().applyMutation(lambda)).build());
        }

        public Builder sns(SnsAction var1);

        default public Builder sns(Consumer<SnsAction.Builder> sns) {
            return this.sns((SnsAction)((SnsAction.Builder)SnsAction.builder().applyMutation(sns)).build());
        }

        public Builder sqs(SqsAction var1);

        default public Builder sqs(Consumer<SqsAction.Builder> sqs) {
            return this.sqs((SqsAction)((SqsAction.Builder)SqsAction.builder().applyMutation(sqs)).build());
        }

        public Builder kinesis(KinesisAction var1);

        default public Builder kinesis(Consumer<KinesisAction.Builder> kinesis) {
            return this.kinesis((KinesisAction)((KinesisAction.Builder)KinesisAction.builder().applyMutation(kinesis)).build());
        }

        public Builder republish(RepublishAction var1);

        default public Builder republish(Consumer<RepublishAction.Builder> republish) {
            return this.republish((RepublishAction)((RepublishAction.Builder)RepublishAction.builder().applyMutation(republish)).build());
        }

        public Builder s3(S3Action var1);

        default public Builder s3(Consumer<S3Action.Builder> s3) {
            return this.s3((S3Action)((S3Action.Builder)S3Action.builder().applyMutation(s3)).build());
        }

        public Builder firehose(FirehoseAction var1);

        default public Builder firehose(Consumer<FirehoseAction.Builder> firehose) {
            return this.firehose((FirehoseAction)((FirehoseAction.Builder)FirehoseAction.builder().applyMutation(firehose)).build());
        }

        public Builder cloudwatchMetric(CloudwatchMetricAction var1);

        default public Builder cloudwatchMetric(Consumer<CloudwatchMetricAction.Builder> cloudwatchMetric) {
            return this.cloudwatchMetric((CloudwatchMetricAction)((CloudwatchMetricAction.Builder)CloudwatchMetricAction.builder().applyMutation(cloudwatchMetric)).build());
        }

        public Builder cloudwatchAlarm(CloudwatchAlarmAction var1);

        default public Builder cloudwatchAlarm(Consumer<CloudwatchAlarmAction.Builder> cloudwatchAlarm) {
            return this.cloudwatchAlarm((CloudwatchAlarmAction)((CloudwatchAlarmAction.Builder)CloudwatchAlarmAction.builder().applyMutation(cloudwatchAlarm)).build());
        }

        public Builder cloudwatchLogs(CloudwatchLogsAction var1);

        default public Builder cloudwatchLogs(Consumer<CloudwatchLogsAction.Builder> cloudwatchLogs) {
            return this.cloudwatchLogs((CloudwatchLogsAction)((CloudwatchLogsAction.Builder)CloudwatchLogsAction.builder().applyMutation(cloudwatchLogs)).build());
        }

        public Builder elasticsearch(ElasticsearchAction var1);

        default public Builder elasticsearch(Consumer<ElasticsearchAction.Builder> elasticsearch) {
            return this.elasticsearch((ElasticsearchAction)((ElasticsearchAction.Builder)ElasticsearchAction.builder().applyMutation(elasticsearch)).build());
        }

        public Builder salesforce(SalesforceAction var1);

        default public Builder salesforce(Consumer<SalesforceAction.Builder> salesforce) {
            return this.salesforce((SalesforceAction)((SalesforceAction.Builder)SalesforceAction.builder().applyMutation(salesforce)).build());
        }

        public Builder iotAnalytics(IotAnalyticsAction var1);

        default public Builder iotAnalytics(Consumer<IotAnalyticsAction.Builder> iotAnalytics) {
            return this.iotAnalytics((IotAnalyticsAction)((IotAnalyticsAction.Builder)IotAnalyticsAction.builder().applyMutation(iotAnalytics)).build());
        }

        public Builder iotEvents(IotEventsAction var1);

        default public Builder iotEvents(Consumer<IotEventsAction.Builder> iotEvents) {
            return this.iotEvents((IotEventsAction)((IotEventsAction.Builder)IotEventsAction.builder().applyMutation(iotEvents)).build());
        }

        public Builder iotSiteWise(IotSiteWiseAction var1);

        default public Builder iotSiteWise(Consumer<IotSiteWiseAction.Builder> iotSiteWise) {
            return this.iotSiteWise((IotSiteWiseAction)((IotSiteWiseAction.Builder)IotSiteWiseAction.builder().applyMutation(iotSiteWise)).build());
        }

        public Builder stepFunctions(StepFunctionsAction var1);

        default public Builder stepFunctions(Consumer<StepFunctionsAction.Builder> stepFunctions) {
            return this.stepFunctions((StepFunctionsAction)((StepFunctionsAction.Builder)StepFunctionsAction.builder().applyMutation(stepFunctions)).build());
        }

        public Builder timestream(TimestreamAction var1);

        default public Builder timestream(Consumer<TimestreamAction.Builder> timestream) {
            return this.timestream((TimestreamAction)((TimestreamAction.Builder)TimestreamAction.builder().applyMutation(timestream)).build());
        }

        public Builder http(HttpAction var1);

        default public Builder http(Consumer<HttpAction.Builder> http) {
            return this.http((HttpAction)((HttpAction.Builder)HttpAction.builder().applyMutation(http)).build());
        }

        public Builder kafka(KafkaAction var1);

        default public Builder kafka(Consumer<KafkaAction.Builder> kafka) {
            return this.kafka((KafkaAction)((KafkaAction.Builder)KafkaAction.builder().applyMutation(kafka)).build());
        }

        public Builder openSearch(OpenSearchAction var1);

        default public Builder openSearch(Consumer<OpenSearchAction.Builder> openSearch) {
            return this.openSearch((OpenSearchAction)((OpenSearchAction.Builder)OpenSearchAction.builder().applyMutation(openSearch)).build());
        }

        public Builder location(LocationAction var1);

        default public Builder location(Consumer<LocationAction.Builder> location) {
            return this.location((LocationAction)((LocationAction.Builder)LocationAction.builder().applyMutation(location)).build());
        }
    }
}

