/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.TopicRulePayload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTopicRuleRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateTopicRuleRequest> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleName").getter(CreateTopicRuleRequest.getter(CreateTopicRuleRequest::ruleName)).setter(CreateTopicRuleRequest.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ruleName").build()}).build();
    private static final SdkField<TopicRulePayload> TOPIC_RULE_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("topicRulePayload").getter(CreateTopicRuleRequest.getter(CreateTopicRuleRequest::topicRulePayload)).setter(CreateTopicRuleRequest.setter(Builder::topicRulePayload)).constructor(TopicRulePayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicRulePayload").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tags").getter(CreateTopicRuleRequest.getter(CreateTopicRuleRequest::tags)).setter(CreateTopicRuleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-tagging").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, TOPIC_RULE_PAYLOAD_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ruleName", RULE_NAME_FIELD);
            this.put("topicRulePayload", TOPIC_RULE_PAYLOAD_FIELD);
            this.put("x-amz-tagging", TAGS_FIELD);
        }
    });
    private final String ruleName;
    private final TopicRulePayload topicRulePayload;
    private final String tags;

    private CreateTopicRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.topicRulePayload = builder.topicRulePayload;
        this.tags = builder.tags;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final TopicRulePayload topicRulePayload() {
        return this.topicRulePayload;
    }

    public final String tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicRulePayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTopicRuleRequest)) {
            return false;
        }
        CreateTopicRuleRequest other = (CreateTopicRuleRequest)((Object)obj);
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.topicRulePayload(), other.topicRulePayload()) && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTopicRuleRequest").add("RuleName", (Object)this.ruleName()).add("TopicRulePayload", (Object)this.topicRulePayload()).add("Tags", (Object)this.tags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "topicRulePayload": {
                return Optional.ofNullable(clazz.cast(this.topicRulePayload()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateTopicRuleRequest, T> g) {
        return obj -> g.apply((CreateTopicRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String ruleName;
        private TopicRulePayload topicRulePayload;
        private String tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTopicRuleRequest model) {
            super(model);
            this.ruleName(model.ruleName);
            this.topicRulePayload(model.topicRulePayload);
            this.tags(model.tags);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final TopicRulePayload.Builder getTopicRulePayload() {
            return this.topicRulePayload != null ? this.topicRulePayload.toBuilder() : null;
        }

        public final void setTopicRulePayload(TopicRulePayload.BuilderImpl topicRulePayload) {
            this.topicRulePayload = topicRulePayload != null ? topicRulePayload.build() : null;
        }

        @Override
        public final Builder topicRulePayload(TopicRulePayload topicRulePayload) {
            this.topicRulePayload = topicRulePayload;
            return this;
        }

        public final String getTags() {
            return this.tags;
        }

        public final void setTags(String tags) {
            this.tags = tags;
        }

        @Override
        public final Builder tags(String tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTopicRuleRequest build() {
            return new CreateTopicRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTopicRuleRequest> {
        public Builder ruleName(String var1);

        public Builder topicRulePayload(TopicRulePayload var1);

        default public Builder topicRulePayload(Consumer<TopicRulePayload.Builder> topicRulePayload) {
            return this.topicRulePayload((TopicRulePayload)((TopicRulePayload.Builder)TopicRulePayload.builder().applyMutation(topicRulePayload)).build());
        }

        public Builder tags(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

