/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AbortConfig;
import software.amazon.awssdk.services.iot.model.DestinationPackageVersionsCopier;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.JobExecutionsRetryConfig;
import software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig;
import software.amazon.awssdk.services.iot.model.JobTargetsCopier;
import software.amazon.awssdk.services.iot.model.ParameterMapCopier;
import software.amazon.awssdk.services.iot.model.PresignedUrlConfig;
import software.amazon.awssdk.services.iot.model.SchedulingConfig;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.services.iot.model.TargetSelection;
import software.amazon.awssdk.services.iot.model.TimeoutConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateJobRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(CreateJobRequest.getter(CreateJobRequest::jobId)).setter(CreateJobRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<List<String>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targets").getter(CreateJobRequest.getter(CreateJobRequest::targets)).setter(CreateJobRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentSource").getter(CreateJobRequest.getter(CreateJobRequest::documentSource)).setter(CreateJobRequest.setter(Builder::documentSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentSource").build()}).build();
    private static final SdkField<String> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("document").getter(CreateJobRequest.getter(CreateJobRequest::document)).setter(CreateJobRequest.setter(Builder::document)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateJobRequest.getter(CreateJobRequest::description)).setter(CreateJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<PresignedUrlConfig> PRESIGNED_URL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("presignedUrlConfig").getter(CreateJobRequest.getter(CreateJobRequest::presignedUrlConfig)).setter(CreateJobRequest.setter(Builder::presignedUrlConfig)).constructor(PresignedUrlConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrlConfig").build()}).build();
    private static final SdkField<String> TARGET_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetSelection").getter(CreateJobRequest.getter(CreateJobRequest::targetSelectionAsString)).setter(CreateJobRequest.setter(Builder::targetSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSelection").build()}).build();
    private static final SdkField<JobExecutionsRolloutConfig> JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobExecutionsRolloutConfig").getter(CreateJobRequest.getter(CreateJobRequest::jobExecutionsRolloutConfig)).setter(CreateJobRequest.setter(Builder::jobExecutionsRolloutConfig)).constructor(JobExecutionsRolloutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRolloutConfig").build()}).build();
    private static final SdkField<AbortConfig> ABORT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("abortConfig").getter(CreateJobRequest.getter(CreateJobRequest::abortConfig)).setter(CreateJobRequest.setter(Builder::abortConfig)).constructor(AbortConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortConfig").build()}).build();
    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeoutConfig").getter(CreateJobRequest.getter(CreateJobRequest::timeoutConfig)).setter(CreateJobRequest.setter(Builder::timeoutConfig)).constructor(TimeoutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateJobRequest.getter(CreateJobRequest::tags)).setter(CreateJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceId").getter(CreateJobRequest.getter(CreateJobRequest::namespaceId)).setter(CreateJobRequest.setter(Builder::namespaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceId").build()}).build();
    private static final SdkField<String> JOB_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobTemplateArn").getter(CreateJobRequest.getter(CreateJobRequest::jobTemplateArn)).setter(CreateJobRequest.setter(Builder::jobTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateArn").build()}).build();
    private static final SdkField<JobExecutionsRetryConfig> JOB_EXECUTIONS_RETRY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobExecutionsRetryConfig").getter(CreateJobRequest.getter(CreateJobRequest::jobExecutionsRetryConfig)).setter(CreateJobRequest.setter(Builder::jobExecutionsRetryConfig)).constructor(JobExecutionsRetryConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRetryConfig").build()}).build();
    private static final SdkField<Map<String, String>> DOCUMENT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("documentParameters").getter(CreateJobRequest.getter(CreateJobRequest::documentParameters)).setter(CreateJobRequest.setter(Builder::documentParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<SchedulingConfig> SCHEDULING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedulingConfig").getter(CreateJobRequest.getter(CreateJobRequest::schedulingConfig)).setter(CreateJobRequest.setter(Builder::schedulingConfig)).constructor(SchedulingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingConfig").build()}).build();
    private static final SdkField<List<String>> DESTINATION_PACKAGE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinationPackageVersions").getter(CreateJobRequest.getter(CreateJobRequest::destinationPackageVersions)).setter(CreateJobRequest.setter(Builder::destinationPackageVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPackageVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, TARGETS_FIELD, DOCUMENT_SOURCE_FIELD, DOCUMENT_FIELD, DESCRIPTION_FIELD, PRESIGNED_URL_CONFIG_FIELD, TARGET_SELECTION_FIELD, JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, ABORT_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD, TAGS_FIELD, NAMESPACE_ID_FIELD, JOB_TEMPLATE_ARN_FIELD, JOB_EXECUTIONS_RETRY_CONFIG_FIELD, DOCUMENT_PARAMETERS_FIELD, SCHEDULING_CONFIG_FIELD, DESTINATION_PACKAGE_VERSIONS_FIELD));
    private final String jobId;
    private final List<String> targets;
    private final String documentSource;
    private final String document;
    private final String description;
    private final PresignedUrlConfig presignedUrlConfig;
    private final String targetSelection;
    private final JobExecutionsRolloutConfig jobExecutionsRolloutConfig;
    private final AbortConfig abortConfig;
    private final TimeoutConfig timeoutConfig;
    private final List<Tag> tags;
    private final String namespaceId;
    private final String jobTemplateArn;
    private final JobExecutionsRetryConfig jobExecutionsRetryConfig;
    private final Map<String, String> documentParameters;
    private final SchedulingConfig schedulingConfig;
    private final List<String> destinationPackageVersions;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.targets = builder.targets;
        this.documentSource = builder.documentSource;
        this.document = builder.document;
        this.description = builder.description;
        this.presignedUrlConfig = builder.presignedUrlConfig;
        this.targetSelection = builder.targetSelection;
        this.jobExecutionsRolloutConfig = builder.jobExecutionsRolloutConfig;
        this.abortConfig = builder.abortConfig;
        this.timeoutConfig = builder.timeoutConfig;
        this.tags = builder.tags;
        this.namespaceId = builder.namespaceId;
        this.jobTemplateArn = builder.jobTemplateArn;
        this.jobExecutionsRetryConfig = builder.jobExecutionsRetryConfig;
        this.documentParameters = builder.documentParameters;
        this.schedulingConfig = builder.schedulingConfig;
        this.destinationPackageVersions = builder.destinationPackageVersions;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<String> targets() {
        return this.targets;
    }

    public final String documentSource() {
        return this.documentSource;
    }

    public final String document() {
        return this.document;
    }

    public final String description() {
        return this.description;
    }

    public final PresignedUrlConfig presignedUrlConfig() {
        return this.presignedUrlConfig;
    }

    public final TargetSelection targetSelection() {
        return TargetSelection.fromValue(this.targetSelection);
    }

    public final String targetSelectionAsString() {
        return this.targetSelection;
    }

    public final JobExecutionsRolloutConfig jobExecutionsRolloutConfig() {
        return this.jobExecutionsRolloutConfig;
    }

    public final AbortConfig abortConfig() {
        return this.abortConfig;
    }

    public final TimeoutConfig timeoutConfig() {
        return this.timeoutConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String namespaceId() {
        return this.namespaceId;
    }

    public final String jobTemplateArn() {
        return this.jobTemplateArn;
    }

    public final JobExecutionsRetryConfig jobExecutionsRetryConfig() {
        return this.jobExecutionsRetryConfig;
    }

    public final boolean hasDocumentParameters() {
        return this.documentParameters != null && !(this.documentParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> documentParameters() {
        return this.documentParameters;
    }

    public final SchedulingConfig schedulingConfig() {
        return this.schedulingConfig;
    }

    public final boolean hasDestinationPackageVersions() {
        return this.destinationPackageVersions != null && !(this.destinationPackageVersions instanceof SdkAutoConstructList);
    }

    public final List<String> destinationPackageVersions() {
        return this.destinationPackageVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.presignedUrlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionsRetryConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentParameters() ? this.documentParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPackageVersions() ? this.destinationPackageVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.documentSource(), other.documentSource()) && Objects.equals(this.document(), other.document()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.presignedUrlConfig(), other.presignedUrlConfig()) && Objects.equals(this.targetSelectionAsString(), other.targetSelectionAsString()) && Objects.equals(this.jobExecutionsRolloutConfig(), other.jobExecutionsRolloutConfig()) && Objects.equals(this.abortConfig(), other.abortConfig()) && Objects.equals(this.timeoutConfig(), other.timeoutConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.namespaceId(), other.namespaceId()) && Objects.equals(this.jobTemplateArn(), other.jobTemplateArn()) && Objects.equals(this.jobExecutionsRetryConfig(), other.jobExecutionsRetryConfig()) && this.hasDocumentParameters() == other.hasDocumentParameters() && Objects.equals(this.documentParameters(), other.documentParameters()) && Objects.equals(this.schedulingConfig(), other.schedulingConfig()) && this.hasDestinationPackageVersions() == other.hasDestinationPackageVersions() && Objects.equals(this.destinationPackageVersions(), other.destinationPackageVersions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateJobRequest").add("JobId", (Object)this.jobId()).add("Targets", this.hasTargets() ? this.targets() : null).add("DocumentSource", (Object)this.documentSource()).add("Document", (Object)this.document()).add("Description", (Object)this.description()).add("PresignedUrlConfig", (Object)this.presignedUrlConfig()).add("TargetSelection", (Object)this.targetSelectionAsString()).add("JobExecutionsRolloutConfig", (Object)this.jobExecutionsRolloutConfig()).add("AbortConfig", (Object)this.abortConfig()).add("TimeoutConfig", (Object)this.timeoutConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("NamespaceId", (Object)this.namespaceId()).add("JobTemplateArn", (Object)this.jobTemplateArn()).add("JobExecutionsRetryConfig", (Object)this.jobExecutionsRetryConfig()).add("DocumentParameters", this.hasDocumentParameters() ? this.documentParameters() : null).add("SchedulingConfig", (Object)this.schedulingConfig()).add("DestinationPackageVersions", this.hasDestinationPackageVersions() ? this.destinationPackageVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "documentSource": {
                return Optional.ofNullable(clazz.cast(this.documentSource()));
            }
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "presignedUrlConfig": {
                return Optional.ofNullable(clazz.cast(this.presignedUrlConfig()));
            }
            case "targetSelection": {
                return Optional.ofNullable(clazz.cast(this.targetSelectionAsString()));
            }
            case "jobExecutionsRolloutConfig": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionsRolloutConfig()));
            }
            case "abortConfig": {
                return Optional.ofNullable(clazz.cast(this.abortConfig()));
            }
            case "timeoutConfig": {
                return Optional.ofNullable(clazz.cast(this.timeoutConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "namespaceId": {
                return Optional.ofNullable(clazz.cast(this.namespaceId()));
            }
            case "jobTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.jobTemplateArn()));
            }
            case "jobExecutionsRetryConfig": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionsRetryConfig()));
            }
            case "documentParameters": {
                return Optional.ofNullable(clazz.cast(this.documentParameters()));
            }
            case "schedulingConfig": {
                return Optional.ofNullable(clazz.cast(this.schedulingConfig()));
            }
            case "destinationPackageVersions": {
                return Optional.ofNullable(clazz.cast(this.destinationPackageVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();
        private String documentSource;
        private String document;
        private String description;
        private PresignedUrlConfig presignedUrlConfig;
        private String targetSelection;
        private JobExecutionsRolloutConfig jobExecutionsRolloutConfig;
        private AbortConfig abortConfig;
        private TimeoutConfig timeoutConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String namespaceId;
        private String jobTemplateArn;
        private JobExecutionsRetryConfig jobExecutionsRetryConfig;
        private Map<String, String> documentParameters = DefaultSdkAutoConstructMap.getInstance();
        private SchedulingConfig schedulingConfig;
        private List<String> destinationPackageVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            this.jobId(model.jobId);
            this.targets(model.targets);
            this.documentSource(model.documentSource);
            this.document(model.document);
            this.description(model.description);
            this.presignedUrlConfig(model.presignedUrlConfig);
            this.targetSelection(model.targetSelection);
            this.jobExecutionsRolloutConfig(model.jobExecutionsRolloutConfig);
            this.abortConfig(model.abortConfig);
            this.timeoutConfig(model.timeoutConfig);
            this.tags(model.tags);
            this.namespaceId(model.namespaceId);
            this.jobTemplateArn(model.jobTemplateArn);
            this.jobExecutionsRetryConfig(model.jobExecutionsRetryConfig);
            this.documentParameters(model.documentParameters);
            this.schedulingConfig(model.schedulingConfig);
            this.destinationPackageVersions(model.destinationPackageVersions);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Collection<String> getTargets() {
            if (this.targets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = JobTargetsCopier.copy(targets);
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = JobTargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final String getDocumentSource() {
            return this.documentSource;
        }

        public final void setDocumentSource(String documentSource) {
            this.documentSource = documentSource;
        }

        @Override
        public final Builder documentSource(String documentSource) {
            this.documentSource = documentSource;
            return this;
        }

        public final String getDocument() {
            return this.document;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PresignedUrlConfig.Builder getPresignedUrlConfig() {
            return this.presignedUrlConfig != null ? this.presignedUrlConfig.toBuilder() : null;
        }

        public final void setPresignedUrlConfig(PresignedUrlConfig.BuilderImpl presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig != null ? presignedUrlConfig.build() : null;
        }

        @Override
        public final Builder presignedUrlConfig(PresignedUrlConfig presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig;
            return this;
        }

        public final String getTargetSelection() {
            return this.targetSelection;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        @Override
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection == null ? null : targetSelection.toString());
            return this;
        }

        public final JobExecutionsRolloutConfig.Builder getJobExecutionsRolloutConfig() {
            return this.jobExecutionsRolloutConfig != null ? this.jobExecutionsRolloutConfig.toBuilder() : null;
        }

        public final void setJobExecutionsRolloutConfig(JobExecutionsRolloutConfig.BuilderImpl jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.build() : null;
        }

        @Override
        public final Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
            return this;
        }

        public final AbortConfig.Builder getAbortConfig() {
            return this.abortConfig != null ? this.abortConfig.toBuilder() : null;
        }

        public final void setAbortConfig(AbortConfig.BuilderImpl abortConfig) {
            this.abortConfig = abortConfig != null ? abortConfig.build() : null;
        }

        @Override
        public final Builder abortConfig(AbortConfig abortConfig) {
            this.abortConfig = abortConfig;
            return this;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return this.timeoutConfig != null ? this.timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNamespaceId() {
            return this.namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final String getJobTemplateArn() {
            return this.jobTemplateArn;
        }

        public final void setJobTemplateArn(String jobTemplateArn) {
            this.jobTemplateArn = jobTemplateArn;
        }

        @Override
        public final Builder jobTemplateArn(String jobTemplateArn) {
            this.jobTemplateArn = jobTemplateArn;
            return this;
        }

        public final JobExecutionsRetryConfig.Builder getJobExecutionsRetryConfig() {
            return this.jobExecutionsRetryConfig != null ? this.jobExecutionsRetryConfig.toBuilder() : null;
        }

        public final void setJobExecutionsRetryConfig(JobExecutionsRetryConfig.BuilderImpl jobExecutionsRetryConfig) {
            this.jobExecutionsRetryConfig = jobExecutionsRetryConfig != null ? jobExecutionsRetryConfig.build() : null;
        }

        @Override
        public final Builder jobExecutionsRetryConfig(JobExecutionsRetryConfig jobExecutionsRetryConfig) {
            this.jobExecutionsRetryConfig = jobExecutionsRetryConfig;
            return this;
        }

        public final Map<String, String> getDocumentParameters() {
            if (this.documentParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.documentParameters;
        }

        public final void setDocumentParameters(Map<String, String> documentParameters) {
            this.documentParameters = ParameterMapCopier.copy(documentParameters);
        }

        @Override
        public final Builder documentParameters(Map<String, String> documentParameters) {
            this.documentParameters = ParameterMapCopier.copy(documentParameters);
            return this;
        }

        public final SchedulingConfig.Builder getSchedulingConfig() {
            return this.schedulingConfig != null ? this.schedulingConfig.toBuilder() : null;
        }

        public final void setSchedulingConfig(SchedulingConfig.BuilderImpl schedulingConfig) {
            this.schedulingConfig = schedulingConfig != null ? schedulingConfig.build() : null;
        }

        @Override
        public final Builder schedulingConfig(SchedulingConfig schedulingConfig) {
            this.schedulingConfig = schedulingConfig;
            return this;
        }

        public final Collection<String> getDestinationPackageVersions() {
            if (this.destinationPackageVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationPackageVersions;
        }

        public final void setDestinationPackageVersions(Collection<String> destinationPackageVersions) {
            this.destinationPackageVersions = DestinationPackageVersionsCopier.copy(destinationPackageVersions);
        }

        @Override
        public final Builder destinationPackageVersions(Collection<String> destinationPackageVersions) {
            this.destinationPackageVersions = DestinationPackageVersionsCopier.copy(destinationPackageVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPackageVersions(String ... destinationPackageVersions) {
            this.destinationPackageVersions(Arrays.asList(destinationPackageVersions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJobRequest> {
        public Builder jobId(String var1);

        public Builder targets(Collection<String> var1);

        public Builder targets(String ... var1);

        public Builder documentSource(String var1);

        public Builder document(String var1);

        public Builder description(String var1);

        public Builder presignedUrlConfig(PresignedUrlConfig var1);

        default public Builder presignedUrlConfig(Consumer<PresignedUrlConfig.Builder> presignedUrlConfig) {
            return this.presignedUrlConfig((PresignedUrlConfig)((PresignedUrlConfig.Builder)PresignedUrlConfig.builder().applyMutation(presignedUrlConfig)).build());
        }

        public Builder targetSelection(String var1);

        public Builder targetSelection(TargetSelection var1);

        public Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig var1);

        default public Builder jobExecutionsRolloutConfig(Consumer<JobExecutionsRolloutConfig.Builder> jobExecutionsRolloutConfig) {
            return this.jobExecutionsRolloutConfig((JobExecutionsRolloutConfig)((JobExecutionsRolloutConfig.Builder)JobExecutionsRolloutConfig.builder().applyMutation(jobExecutionsRolloutConfig)).build());
        }

        public Builder abortConfig(AbortConfig var1);

        default public Builder abortConfig(Consumer<AbortConfig.Builder> abortConfig) {
            return this.abortConfig((AbortConfig)((AbortConfig.Builder)AbortConfig.builder().applyMutation(abortConfig)).build());
        }

        public Builder timeoutConfig(TimeoutConfig var1);

        default public Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return this.timeoutConfig((TimeoutConfig)((TimeoutConfig.Builder)TimeoutConfig.builder().applyMutation(timeoutConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder namespaceId(String var1);

        public Builder jobTemplateArn(String var1);

        public Builder jobExecutionsRetryConfig(JobExecutionsRetryConfig var1);

        default public Builder jobExecutionsRetryConfig(Consumer<JobExecutionsRetryConfig.Builder> jobExecutionsRetryConfig) {
            return this.jobExecutionsRetryConfig((JobExecutionsRetryConfig)((JobExecutionsRetryConfig.Builder)JobExecutionsRetryConfig.builder().applyMutation(jobExecutionsRetryConfig)).build());
        }

        public Builder documentParameters(Map<String, String> var1);

        public Builder schedulingConfig(SchedulingConfig var1);

        default public Builder schedulingConfig(Consumer<SchedulingConfig.Builder> schedulingConfig) {
            return this.schedulingConfig((SchedulingConfig)((SchedulingConfig.Builder)SchedulingConfig.builder().applyMutation(schedulingConfig)).build());
        }

        public Builder destinationPackageVersions(Collection<String> var1);

        public Builder destinationPackageVersions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

