/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListSbomValidationResultsRequest;
import software.amazon.awssdk.services.iot.model.ListSbomValidationResultsResponse;
import software.amazon.awssdk.services.iot.model.SbomValidationResultSummary;

public class ListSbomValidationResultsIterable
implements SdkIterable<ListSbomValidationResultsResponse> {
    private final IotClient client;
    private final ListSbomValidationResultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSbomValidationResultsIterable(IotClient client, ListSbomValidationResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSbomValidationResultsResponseFetcher();
    }

    public Iterator<ListSbomValidationResultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SbomValidationResultSummary> validationResultSummaries() {
        Function<ListSbomValidationResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.validationResultSummaries() != null) {
                return response.validationResultSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSbomValidationResultsResponseFetcher
    implements SyncPageFetcher<ListSbomValidationResultsResponse> {
        private ListSbomValidationResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListSbomValidationResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSbomValidationResultsResponse nextPage(ListSbomValidationResultsResponse previousPage) {
            if (previousPage == null) {
                return ListSbomValidationResultsIterable.this.client.listSbomValidationResults(ListSbomValidationResultsIterable.this.firstRequest);
            }
            return ListSbomValidationResultsIterable.this.client.listSbomValidationResults((ListSbomValidationResultsRequest)((Object)ListSbomValidationResultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

