/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.JobTemplateSummary;
import software.amazon.awssdk.services.iot.model.JobTemplateSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobTemplatesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListJobTemplatesResponse> {
    private static final SdkField<List<JobTemplateSummary>> JOB_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobTemplates").getter(ListJobTemplatesResponse.getter(ListJobTemplatesResponse::jobTemplates)).setter(ListJobTemplatesResponse.setter(Builder::jobTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobTemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListJobTemplatesResponse.getter(ListJobTemplatesResponse::nextToken)).setter(ListJobTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private final List<JobTemplateSummary> jobTemplates;
    private final String nextToken;

    private ListJobTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.jobTemplates = builder.jobTemplates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasJobTemplates() {
        return this.jobTemplates != null && !(this.jobTemplates instanceof SdkAutoConstructList);
    }

    public final List<JobTemplateSummary> jobTemplates() {
        return this.jobTemplates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobTemplates() ? this.jobTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobTemplatesResponse)) {
            return false;
        }
        ListJobTemplatesResponse other = (ListJobTemplatesResponse)((Object)obj);
        return this.hasJobTemplates() == other.hasJobTemplates() && Objects.equals(this.jobTemplates(), other.jobTemplates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListJobTemplatesResponse").add("JobTemplates", this.hasJobTemplates() ? this.jobTemplates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobTemplates": {
                return Optional.ofNullable(clazz.cast(this.jobTemplates()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobTemplatesResponse, T> g) {
        return obj -> g.apply((ListJobTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<JobTemplateSummary> jobTemplates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobTemplatesResponse model) {
            super(model);
            this.jobTemplates(model.jobTemplates);
            this.nextToken(model.nextToken);
        }

        public final List<JobTemplateSummary.Builder> getJobTemplates() {
            List<JobTemplateSummary.Builder> result = JobTemplateSummaryListCopier.copyToBuilder(this.jobTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTemplates(Collection<JobTemplateSummary.BuilderImpl> jobTemplates) {
            this.jobTemplates = JobTemplateSummaryListCopier.copyFromBuilder(jobTemplates);
        }

        @Override
        public final Builder jobTemplates(Collection<JobTemplateSummary> jobTemplates) {
            this.jobTemplates = JobTemplateSummaryListCopier.copy(jobTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTemplates(JobTemplateSummary ... jobTemplates) {
            this.jobTemplates(Arrays.asList(jobTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTemplates(Consumer<JobTemplateSummary.Builder> ... jobTemplates) {
            this.jobTemplates(Stream.of(jobTemplates).map(c -> (JobTemplateSummary)((JobTemplateSummary.Builder)JobTemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListJobTemplatesResponse build() {
            return new ListJobTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobTemplatesResponse> {
        public Builder jobTemplates(Collection<JobTemplateSummary> var1);

        public Builder jobTemplates(JobTemplateSummary ... var1);

        public Builder jobTemplates(Consumer<JobTemplateSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

