/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.OutgoingCertificate;
import software.amazon.awssdk.services.iot.model.OutgoingCertificatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOutgoingCertificatesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListOutgoingCertificatesResponse> {
    private static final SdkField<List<OutgoingCertificate>> OUTGOING_CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outgoingCertificates").getter(ListOutgoingCertificatesResponse.getter(ListOutgoingCertificatesResponse::outgoingCertificates)).setter(ListOutgoingCertificatesResponse.setter(Builder::outgoingCertificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outgoingCertificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutgoingCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextMarker").getter(ListOutgoingCertificatesResponse.getter(ListOutgoingCertificatesResponse::nextMarker)).setter(ListOutgoingCertificatesResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTGOING_CERTIFICATES_FIELD, NEXT_MARKER_FIELD));
    private final List<OutgoingCertificate> outgoingCertificates;
    private final String nextMarker;

    private ListOutgoingCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.outgoingCertificates = builder.outgoingCertificates;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasOutgoingCertificates() {
        return this.outgoingCertificates != null && !(this.outgoingCertificates instanceof SdkAutoConstructList);
    }

    public final List<OutgoingCertificate> outgoingCertificates() {
        return this.outgoingCertificates;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutgoingCertificates() ? this.outgoingCertificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutgoingCertificatesResponse)) {
            return false;
        }
        ListOutgoingCertificatesResponse other = (ListOutgoingCertificatesResponse)((Object)obj);
        return this.hasOutgoingCertificates() == other.hasOutgoingCertificates() && Objects.equals(this.outgoingCertificates(), other.outgoingCertificates()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListOutgoingCertificatesResponse").add("OutgoingCertificates", this.hasOutgoingCertificates() ? this.outgoingCertificates() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outgoingCertificates": {
                return Optional.ofNullable(clazz.cast(this.outgoingCertificates()));
            }
            case "nextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOutgoingCertificatesResponse, T> g) {
        return obj -> g.apply((ListOutgoingCertificatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<OutgoingCertificate> outgoingCertificates = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutgoingCertificatesResponse model) {
            super(model);
            this.outgoingCertificates(model.outgoingCertificates);
            this.nextMarker(model.nextMarker);
        }

        public final List<OutgoingCertificate.Builder> getOutgoingCertificates() {
            List<OutgoingCertificate.Builder> result = OutgoingCertificatesCopier.copyToBuilder(this.outgoingCertificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutgoingCertificates(Collection<OutgoingCertificate.BuilderImpl> outgoingCertificates) {
            this.outgoingCertificates = OutgoingCertificatesCopier.copyFromBuilder(outgoingCertificates);
        }

        @Override
        public final Builder outgoingCertificates(Collection<OutgoingCertificate> outgoingCertificates) {
            this.outgoingCertificates = OutgoingCertificatesCopier.copy(outgoingCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outgoingCertificates(OutgoingCertificate ... outgoingCertificates) {
            this.outgoingCertificates(Arrays.asList(outgoingCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outgoingCertificates(Consumer<OutgoingCertificate.Builder> ... outgoingCertificates) {
            this.outgoingCertificates(Stream.of(outgoingCertificates).map(c -> (OutgoingCertificate)((OutgoingCertificate.Builder)OutgoingCertificate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListOutgoingCertificatesResponse build() {
            return new ListOutgoingCertificatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOutgoingCertificatesResponse> {
        public Builder outgoingCertificates(Collection<OutgoingCertificate> var1);

        public Builder outgoingCertificates(OutgoingCertificate ... var1);

        public Builder outgoingCertificates(Consumer<OutgoingCertificate.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

