/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary;

public class ListManagedJobTemplatesPublisher
implements SdkPublisher<ListManagedJobTemplatesResponse> {
    private final IotAsyncClient client;
    private final ListManagedJobTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedJobTemplatesPublisher(IotAsyncClient client, ListManagedJobTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedJobTemplatesPublisher(IotAsyncClient client, ListManagedJobTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedJobTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedJobTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedJobTemplateSummary> managedJobTemplates() {
        Function<ListManagedJobTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedJobTemplates() != null) {
                return response.managedJobTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedJobTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedJobTemplatesResponseFetcher
    implements AsyncPageFetcher<ListManagedJobTemplatesResponse> {
        private ListManagedJobTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedJobTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedJobTemplatesResponse> nextPage(ListManagedJobTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListManagedJobTemplatesPublisher.this.client.listManagedJobTemplates(ListManagedJobTemplatesPublisher.this.firstRequest);
            }
            return ListManagedJobTemplatesPublisher.this.client.listManagedJobTemplates((ListManagedJobTemplatesRequest)((Object)ListManagedJobTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

