/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ProvisioningHook;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProvisioningTemplateRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateProvisioningTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(UpdateProvisioningTemplateRequest.getter(UpdateProvisioningTemplateRequest::templateName)).setter(UpdateProvisioningTemplateRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("templateName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateProvisioningTemplateRequest.getter(UpdateProvisioningTemplateRequest::description)).setter(UpdateProvisioningTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(UpdateProvisioningTemplateRequest.getter(UpdateProvisioningTemplateRequest::enabled)).setter(UpdateProvisioningTemplateRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Integer> DEFAULT_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("defaultVersionId").getter(UpdateProvisioningTemplateRequest.getter(UpdateProvisioningTemplateRequest::defaultVersionId)).setter(UpdateProvisioningTemplateRequest.setter(Builder::defaultVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersionId").build()}).build();
    private static final SdkField<String> PROVISIONING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisioningRoleArn").getter(UpdateProvisioningTemplateRequest.getter(UpdateProvisioningTemplateRequest::provisioningRoleArn)).setter(UpdateProvisioningTemplateRequest.setter(Builder::provisioningRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRoleArn").build()}).build();
    private static final SdkField<ProvisioningHook> PRE_PROVISIONING_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("preProvisioningHook").getter(UpdateProvisioningTemplateRequest.getter(UpdateProvisioningTemplateRequest::preProvisioningHook)).setter(UpdateProvisioningTemplateRequest.setter(Builder::preProvisioningHook)).constructor(ProvisioningHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preProvisioningHook").build()}).build();
    private static final SdkField<Boolean> REMOVE_PRE_PROVISIONING_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("removePreProvisioningHook").getter(UpdateProvisioningTemplateRequest.getter(UpdateProvisioningTemplateRequest::removePreProvisioningHook)).setter(UpdateProvisioningTemplateRequest.setter(Builder::removePreProvisioningHook)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removePreProvisioningHook").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, ENABLED_FIELD, DEFAULT_VERSION_ID_FIELD, PROVISIONING_ROLE_ARN_FIELD, PRE_PROVISIONING_HOOK_FIELD, REMOVE_PRE_PROVISIONING_HOOK_FIELD));
    private final String templateName;
    private final String description;
    private final Boolean enabled;
    private final Integer defaultVersionId;
    private final String provisioningRoleArn;
    private final ProvisioningHook preProvisioningHook;
    private final Boolean removePreProvisioningHook;

    private UpdateProvisioningTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.defaultVersionId = builder.defaultVersionId;
        this.provisioningRoleArn = builder.provisioningRoleArn;
        this.preProvisioningHook = builder.preProvisioningHook;
        this.removePreProvisioningHook = builder.removePreProvisioningHook;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Integer defaultVersionId() {
        return this.defaultVersionId;
    }

    public final String provisioningRoleArn() {
        return this.provisioningRoleArn;
    }

    public final ProvisioningHook preProvisioningHook() {
        return this.preProvisioningHook;
    }

    public final Boolean removePreProvisioningHook() {
        return this.removePreProvisioningHook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.preProvisioningHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.removePreProvisioningHook());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisioningTemplateRequest)) {
            return false;
        }
        UpdateProvisioningTemplateRequest other = (UpdateProvisioningTemplateRequest)((Object)obj);
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.defaultVersionId(), other.defaultVersionId()) && Objects.equals(this.provisioningRoleArn(), other.provisioningRoleArn()) && Objects.equals(this.preProvisioningHook(), other.preProvisioningHook()) && Objects.equals(this.removePreProvisioningHook(), other.removePreProvisioningHook());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProvisioningTemplateRequest").add("TemplateName", (Object)this.templateName()).add("Description", (Object)this.description()).add("Enabled", (Object)this.enabled()).add("DefaultVersionId", (Object)this.defaultVersionId()).add("ProvisioningRoleArn", (Object)this.provisioningRoleArn()).add("PreProvisioningHook", (Object)this.preProvisioningHook()).add("RemovePreProvisioningHook", (Object)this.removePreProvisioningHook()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "defaultVersionId": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionId()));
            }
            case "provisioningRoleArn": {
                return Optional.ofNullable(clazz.cast(this.provisioningRoleArn()));
            }
            case "preProvisioningHook": {
                return Optional.ofNullable(clazz.cast(this.preProvisioningHook()));
            }
            case "removePreProvisioningHook": {
                return Optional.ofNullable(clazz.cast(this.removePreProvisioningHook()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisioningTemplateRequest, T> g) {
        return obj -> g.apply((UpdateProvisioningTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String templateName;
        private String description;
        private Boolean enabled;
        private Integer defaultVersionId;
        private String provisioningRoleArn;
        private ProvisioningHook preProvisioningHook;
        private Boolean removePreProvisioningHook;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisioningTemplateRequest model) {
            super(model);
            this.templateName(model.templateName);
            this.description(model.description);
            this.enabled(model.enabled);
            this.defaultVersionId(model.defaultVersionId);
            this.provisioningRoleArn(model.provisioningRoleArn);
            this.preProvisioningHook(model.preProvisioningHook);
            this.removePreProvisioningHook(model.removePreProvisioningHook);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getDefaultVersionId() {
            return this.defaultVersionId;
        }

        public final void setDefaultVersionId(Integer defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(Integer defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final String getProvisioningRoleArn() {
            return this.provisioningRoleArn;
        }

        public final void setProvisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
        }

        @Override
        public final Builder provisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
            return this;
        }

        public final ProvisioningHook.Builder getPreProvisioningHook() {
            return this.preProvisioningHook != null ? this.preProvisioningHook.toBuilder() : null;
        }

        public final void setPreProvisioningHook(ProvisioningHook.BuilderImpl preProvisioningHook) {
            this.preProvisioningHook = preProvisioningHook != null ? preProvisioningHook.build() : null;
        }

        @Override
        public final Builder preProvisioningHook(ProvisioningHook preProvisioningHook) {
            this.preProvisioningHook = preProvisioningHook;
            return this;
        }

        public final Boolean getRemovePreProvisioningHook() {
            return this.removePreProvisioningHook;
        }

        public final void setRemovePreProvisioningHook(Boolean removePreProvisioningHook) {
            this.removePreProvisioningHook = removePreProvisioningHook;
        }

        @Override
        public final Builder removePreProvisioningHook(Boolean removePreProvisioningHook) {
            this.removePreProvisioningHook = removePreProvisioningHook;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProvisioningTemplateRequest build() {
            return new UpdateProvisioningTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProvisioningTemplateRequest> {
        public Builder templateName(String var1);

        public Builder description(String var1);

        public Builder enabled(Boolean var1);

        public Builder defaultVersionId(Integer var1);

        public Builder provisioningRoleArn(String var1);

        public Builder preProvisioningHook(ProvisioningHook var1);

        default public Builder preProvisioningHook(Consumer<ProvisioningHook.Builder> preProvisioningHook) {
            return this.preProvisioningHook((ProvisioningHook)((ProvisioningHook.Builder)ProvisioningHook.builder().applyMutation(preProvisioningHook)).build());
        }

        public Builder removePreProvisioningHook(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

