/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesResponse;

public class ListRoleAliasesPublisher
implements SdkPublisher<ListRoleAliasesResponse> {
    private final IotAsyncClient client;
    private final ListRoleAliasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRoleAliasesPublisher(IotAsyncClient client, ListRoleAliasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRoleAliasesPublisher(IotAsyncClient client, ListRoleAliasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRoleAliasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRoleAliasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> roleAliases() {
        Function<ListRoleAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.roleAliases() != null) {
                return response.roleAliases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRoleAliasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRoleAliasesResponseFetcher
    implements AsyncPageFetcher<ListRoleAliasesResponse> {
        private ListRoleAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListRoleAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListRoleAliasesResponse> nextPage(ListRoleAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListRoleAliasesPublisher.this.client.listRoleAliases(ListRoleAliasesPublisher.this.firstRequest);
            }
            return ListRoleAliasesPublisher.this.client.listRoleAliases((ListRoleAliasesRequest)((Object)ListRoleAliasesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

