/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDetectMitigationActionsTaskRequest extends IotRequest implements
        ToCopyableBuilder<StartDetectMitigationActionsTaskRequest.Builder, StartDetectMitigationActionsTaskRequest> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(StartDetectMitigationActionsTaskRequest::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("taskId").build()).build();

    private static final SdkField<DetectMitigationActionsTaskTarget> TARGET_FIELD = SdkField
            .<DetectMitigationActionsTaskTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(StartDetectMitigationActionsTaskRequest::target)).setter(setter(Builder::target))
            .constructor(DetectMitigationActionsTaskTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(StartDetectMitigationActionsTaskRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ViolationEventOccurrenceRange> VIOLATION_EVENT_OCCURRENCE_RANGE_FIELD = SdkField
            .<ViolationEventOccurrenceRange> builder(MarshallingType.SDK_POJO)
            .memberName("violationEventOccurrenceRange")
            .getter(getter(StartDetectMitigationActionsTaskRequest::violationEventOccurrenceRange))
            .setter(setter(Builder::violationEventOccurrenceRange))
            .constructor(ViolationEventOccurrenceRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEventOccurrenceRange")
                    .build()).build();

    private static final SdkField<Boolean> INCLUDE_ONLY_ACTIVE_VIOLATIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeOnlyActiveViolations")
            .getter(getter(StartDetectMitigationActionsTaskRequest::includeOnlyActiveViolations))
            .setter(setter(Builder::includeOnlyActiveViolations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeOnlyActiveViolations")
                    .build()).build();

    private static final SdkField<Boolean> INCLUDE_SUPPRESSED_ALERTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeSuppressedAlerts")
            .getter(getter(StartDetectMitigationActionsTaskRequest::includeSuppressedAlerts))
            .setter(setter(Builder::includeSuppressedAlerts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeSuppressedAlerts").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(StartDetectMitigationActionsTaskRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TARGET_FIELD,
            ACTIONS_FIELD, VIOLATION_EVENT_OCCURRENCE_RANGE_FIELD, INCLUDE_ONLY_ACTIVE_VIOLATIONS_FIELD,
            INCLUDE_SUPPRESSED_ALERTS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String taskId;

    private final DetectMitigationActionsTaskTarget target;

    private final List<String> actions;

    private final ViolationEventOccurrenceRange violationEventOccurrenceRange;

    private final Boolean includeOnlyActiveViolations;

    private final Boolean includeSuppressedAlerts;

    private final String clientRequestToken;

    private StartDetectMitigationActionsTaskRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.target = builder.target;
        this.actions = builder.actions;
        this.violationEventOccurrenceRange = builder.violationEventOccurrenceRange;
        this.includeOnlyActiveViolations = builder.includeOnlyActiveViolations;
        this.includeSuppressedAlerts = builder.includeSuppressedAlerts;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The unique identifier of the task.
     * </p>
     * 
     * @return The unique identifier of the task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * Specifies the ML Detect findings to which the mitigation actions are applied.
     * </p>
     * 
     * @return Specifies the ML Detect findings to which the mitigation actions are applied.
     */
    public final DetectMitigationActionsTaskTarget target() {
        return target;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to be performed when a device has unexpected behavior.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions to be performed when a device has unexpected behavior.
     */
    public final List<String> actions() {
        return actions;
    }

    /**
     * <p>
     * Specifies the time period of which violation events occurred between.
     * </p>
     * 
     * @return Specifies the time period of which violation events occurred between.
     */
    public final ViolationEventOccurrenceRange violationEventOccurrenceRange() {
        return violationEventOccurrenceRange;
    }

    /**
     * <p>
     * Specifies to list only active violations.
     * </p>
     * 
     * @return Specifies to list only active violations.
     */
    public final Boolean includeOnlyActiveViolations() {
        return includeOnlyActiveViolations;
    }

    /**
     * <p>
     * Specifies to include suppressed alerts.
     * </p>
     * 
     * @return Specifies to include suppressed alerts.
     */
    public final Boolean includeSuppressedAlerts() {
        return includeSuppressedAlerts;
    }

    /**
     * <p>
     * Each mitigation action task must have a unique client request token. If you try to create a new task with the
     * same token as a task that already exists, an exception occurs. If you omit this value, Amazon Web Services SDKs
     * will automatically generate a unique client request.
     * </p>
     * 
     * @return Each mitigation action task must have a unique client request token. If you try to create a new task with
     *         the same token as a task that already exists, an exception occurs. If you omit this value, Amazon Web
     *         Services SDKs will automatically generate a unique client request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(violationEventOccurrenceRange());
        hashCode = 31 * hashCode + Objects.hashCode(includeOnlyActiveViolations());
        hashCode = 31 * hashCode + Objects.hashCode(includeSuppressedAlerts());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDetectMitigationActionsTaskRequest)) {
            return false;
        }
        StartDetectMitigationActionsTaskRequest other = (StartDetectMitigationActionsTaskRequest) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(target(), other.target())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(violationEventOccurrenceRange(), other.violationEventOccurrenceRange())
                && Objects.equals(includeOnlyActiveViolations(), other.includeOnlyActiveViolations())
                && Objects.equals(includeSuppressedAlerts(), other.includeSuppressedAlerts())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDetectMitigationActionsTaskRequest").add("TaskId", taskId()).add("Target", target())
                .add("Actions", hasActions() ? actions() : null)
                .add("ViolationEventOccurrenceRange", violationEventOccurrenceRange())
                .add("IncludeOnlyActiveViolations", includeOnlyActiveViolations())
                .add("IncludeSuppressedAlerts", includeSuppressedAlerts()).add("ClientRequestToken", clientRequestToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "violationEventOccurrenceRange":
            return Optional.ofNullable(clazz.cast(violationEventOccurrenceRange()));
        case "includeOnlyActiveViolations":
            return Optional.ofNullable(clazz.cast(includeOnlyActiveViolations()));
        case "includeSuppressedAlerts":
            return Optional.ofNullable(clazz.cast(includeSuppressedAlerts()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDetectMitigationActionsTaskRequest, T> g) {
        return obj -> g.apply((StartDetectMitigationActionsTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDetectMitigationActionsTaskRequest> {
        /**
         * <p>
         * The unique identifier of the task.
         * </p>
         * 
         * @param taskId
         *        The unique identifier of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * Specifies the ML Detect findings to which the mitigation actions are applied.
         * </p>
         * 
         * @param target
         *        Specifies the ML Detect findings to which the mitigation actions are applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(DetectMitigationActionsTaskTarget target);

        /**
         * <p>
         * Specifies the ML Detect findings to which the mitigation actions are applied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DetectMitigationActionsTaskTarget.Builder} avoiding the need to create one manually via
         * {@link DetectMitigationActionsTaskTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectMitigationActionsTaskTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #target(DetectMitigationActionsTaskTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link DetectMitigationActionsTaskTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(DetectMitigationActionsTaskTarget)
         */
        default Builder target(Consumer<DetectMitigationActionsTaskTarget.Builder> target) {
            return target(DetectMitigationActionsTaskTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * The actions to be performed when a device has unexpected behavior.
         * </p>
         * 
         * @param actions
         *        The actions to be performed when a device has unexpected behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<String> actions);

        /**
         * <p>
         * The actions to be performed when a device has unexpected behavior.
         * </p>
         * 
         * @param actions
         *        The actions to be performed when a device has unexpected behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(String... actions);

        /**
         * <p>
         * Specifies the time period of which violation events occurred between.
         * </p>
         * 
         * @param violationEventOccurrenceRange
         *        Specifies the time period of which violation events occurred between.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationEventOccurrenceRange(ViolationEventOccurrenceRange violationEventOccurrenceRange);

        /**
         * <p>
         * Specifies the time period of which violation events occurred between.
         * </p>
         * This is a convenience method that creates an instance of the {@link ViolationEventOccurrenceRange.Builder}
         * avoiding the need to create one manually via {@link ViolationEventOccurrenceRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViolationEventOccurrenceRange.Builder#build()} is called
         * immediately and its result is passed to {@link #violationEventOccurrenceRange(ViolationEventOccurrenceRange)}.
         * 
         * @param violationEventOccurrenceRange
         *        a consumer that will call methods on {@link ViolationEventOccurrenceRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violationEventOccurrenceRange(ViolationEventOccurrenceRange)
         */
        default Builder violationEventOccurrenceRange(
                Consumer<ViolationEventOccurrenceRange.Builder> violationEventOccurrenceRange) {
            return violationEventOccurrenceRange(ViolationEventOccurrenceRange.builder()
                    .applyMutation(violationEventOccurrenceRange).build());
        }

        /**
         * <p>
         * Specifies to list only active violations.
         * </p>
         * 
         * @param includeOnlyActiveViolations
         *        Specifies to list only active violations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOnlyActiveViolations(Boolean includeOnlyActiveViolations);

        /**
         * <p>
         * Specifies to include suppressed alerts.
         * </p>
         * 
         * @param includeSuppressedAlerts
         *        Specifies to include suppressed alerts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSuppressedAlerts(Boolean includeSuppressedAlerts);

        /**
         * <p>
         * Each mitigation action task must have a unique client request token. If you try to create a new task with the
         * same token as a task that already exists, an exception occurs. If you omit this value, Amazon Web Services
         * SDKs will automatically generate a unique client request.
         * </p>
         * 
         * @param clientRequestToken
         *        Each mitigation action task must have a unique client request token. If you try to create a new task
         *        with the same token as a task that already exists, an exception occurs. If you omit this value, Amazon
         *        Web Services SDKs will automatically generate a unique client request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String taskId;

        private DetectMitigationActionsTaskTarget target;

        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private ViolationEventOccurrenceRange violationEventOccurrenceRange;

        private Boolean includeOnlyActiveViolations;

        private Boolean includeSuppressedAlerts;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDetectMitigationActionsTaskRequest model) {
            super(model);
            taskId(model.taskId);
            target(model.target);
            actions(model.actions);
            violationEventOccurrenceRange(model.violationEventOccurrenceRange);
            includeOnlyActiveViolations(model.includeOnlyActiveViolations);
            includeSuppressedAlerts(model.includeSuppressedAlerts);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final DetectMitigationActionsTaskTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(DetectMitigationActionsTaskTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(DetectMitigationActionsTaskTarget target) {
            this.target = target;
            return this;
        }

        public final Collection<String> getActions() {
            if (actions instanceof SdkAutoConstructList) {
                return null;
            }
            return actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = DetectMitigationActionsToExecuteListCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = DetectMitigationActionsToExecuteListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        public final ViolationEventOccurrenceRange.Builder getViolationEventOccurrenceRange() {
            return violationEventOccurrenceRange != null ? violationEventOccurrenceRange.toBuilder() : null;
        }

        public final void setViolationEventOccurrenceRange(ViolationEventOccurrenceRange.BuilderImpl violationEventOccurrenceRange) {
            this.violationEventOccurrenceRange = violationEventOccurrenceRange != null ? violationEventOccurrenceRange.build()
                    : null;
        }

        @Override
        public final Builder violationEventOccurrenceRange(ViolationEventOccurrenceRange violationEventOccurrenceRange) {
            this.violationEventOccurrenceRange = violationEventOccurrenceRange;
            return this;
        }

        public final Boolean getIncludeOnlyActiveViolations() {
            return includeOnlyActiveViolations;
        }

        public final void setIncludeOnlyActiveViolations(Boolean includeOnlyActiveViolations) {
            this.includeOnlyActiveViolations = includeOnlyActiveViolations;
        }

        @Override
        public final Builder includeOnlyActiveViolations(Boolean includeOnlyActiveViolations) {
            this.includeOnlyActiveViolations = includeOnlyActiveViolations;
            return this;
        }

        public final Boolean getIncludeSuppressedAlerts() {
            return includeSuppressedAlerts;
        }

        public final void setIncludeSuppressedAlerts(Boolean includeSuppressedAlerts) {
            this.includeSuppressedAlerts = includeSuppressedAlerts;
        }

        @Override
        public final Builder includeSuppressedAlerts(Boolean includeSuppressedAlerts) {
            this.includeSuppressedAlerts = includeSuppressedAlerts;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDetectMitigationActionsTaskRequest build() {
            return new StartDetectMitigationActionsTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
