/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An optional configuration within the <code>SchedulingConfig</code> to setup a recurring maintenance window with a
 * predetermined start time and duration for the rollout of a job document to all devices in a target group for a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceWindow implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceWindow.Builder, MaintenanceWindow> {
    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startTime").getter(getter(MaintenanceWindow::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Integer> DURATION_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("durationInMinutes").getter(getter(MaintenanceWindow::durationInMinutes))
            .setter(setter(Builder::durationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            DURATION_IN_MINUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String startTime;

    private final Integer durationInMinutes;

    private MaintenanceWindow(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.durationInMinutes = builder.durationInMinutes;
    }

    /**
     * <p>
     * Displays the start time of the next maintenance window.
     * </p>
     * 
     * @return Displays the start time of the next maintenance window.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * Displays the duration of the next maintenance window.
     * </p>
     * 
     * @return Displays the duration of the next maintenance window.
     */
    public final Integer durationInMinutes() {
        return durationInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(durationInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindow)) {
            return false;
        }
        MaintenanceWindow other = (MaintenanceWindow) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(durationInMinutes(), other.durationInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaintenanceWindow").add("StartTime", startTime()).add("DurationInMinutes", durationInMinutes())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "durationInMinutes":
            return Optional.ofNullable(clazz.cast(durationInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindow, T> g) {
        return obj -> g.apply((MaintenanceWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceWindow> {
        /**
         * <p>
         * Displays the start time of the next maintenance window.
         * </p>
         * 
         * @param startTime
         *        Displays the start time of the next maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * Displays the duration of the next maintenance window.
         * </p>
         * 
         * @param durationInMinutes
         *        Displays the duration of the next maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInMinutes(Integer durationInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String startTime;

        private Integer durationInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindow model) {
            startTime(model.startTime);
            durationInMinutes(model.durationInMinutes);
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Integer getDurationInMinutes() {
            return durationInMinutes;
        }

        public final void setDurationInMinutes(Integer durationInMinutes) {
            this.durationInMinutes = durationInMinutes;
        }

        @Override
        public final Builder durationInMinutes(Integer durationInMinutes) {
            this.durationInMinutes = durationInMinutes;
            return this;
        }

        @Override
        public MaintenanceWindow build() {
            return new MaintenanceWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
