/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information that allowed the authorization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Allowed implements SdkPojo, Serializable, ToCopyableBuilder<Allowed.Builder, Allowed> {
    private static final SdkField<List<Policy>> POLICIES_FIELD = SdkField
            .<List<Policy>> builder(MarshallingType.LIST)
            .memberName("policies")
            .getter(getter(Allowed::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Policy> builder(MarshallingType.SDK_POJO)
                                            .constructor(Policy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Policy> policies;

    private Allowed(BuilderImpl builder) {
        this.policies = builder.policies;
    }

    /**
     * For responses, this returns true if the service returned a value for the Policies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicies() {
        return policies != null && !(policies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of policies that allowed the authentication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicies} method.
     * </p>
     * 
     * @return A list of policies that allowed the authentication.
     */
    public final List<Policy> policies() {
        return policies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicies() ? policies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Allowed)) {
            return false;
        }
        Allowed other = (Allowed) obj;
        return hasPolicies() == other.hasPolicies() && Objects.equals(policies(), other.policies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Allowed").add("Policies", hasPolicies() ? policies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policies":
            return Optional.ofNullable(clazz.cast(policies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Allowed, T> g) {
        return obj -> g.apply((Allowed) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Allowed> {
        /**
         * <p>
         * A list of policies that allowed the authentication.
         * </p>
         * 
         * @param policies
         *        A list of policies that allowed the authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Collection<Policy> policies);

        /**
         * <p>
         * A list of policies that allowed the authentication.
         * </p>
         * 
         * @param policies
         *        A list of policies that allowed the authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Policy... policies);

        /**
         * <p>
         * A list of policies that allowed the authentication.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.Policy.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iot.model.Policy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.iot.model.Policy.Builder#build()}
         * is called immediately and its result is passed to {@link #policies(List<Policy>)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.iot.model.Policy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(java.util.Collection<Policy>)
         */
        Builder policies(Consumer<Policy.Builder>... policies);
    }

    static final class BuilderImpl implements Builder {
        private List<Policy> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Allowed model) {
            policies(model.policies);
        }

        public final List<Policy.Builder> getPolicies() {
            List<Policy.Builder> result = PoliciesCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<Policy.BuilderImpl> policies) {
            this.policies = PoliciesCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<Policy> policies) {
            this.policies = PoliciesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Policy... policies) {
            policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<Policy.Builder>... policies) {
            policies(Stream.of(policies).map(c -> Policy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Allowed build() {
            return new Allowed(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
