/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.JobEndBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchedulingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchedulingConfig> {
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startTime").getter(SchedulingConfig.getter(SchedulingConfig::startTime)).setter(SchedulingConfig.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endTime").getter(SchedulingConfig.getter(SchedulingConfig::endTime)).setter(SchedulingConfig.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> END_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endBehavior").getter(SchedulingConfig.getter(SchedulingConfig::endBehaviorAsString)).setter(SchedulingConfig.setter(Builder::endBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, END_BEHAVIOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String startTime;
    private final String endTime;
    private final String endBehavior;

    private SchedulingConfig(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.endBehavior = builder.endBehavior;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final String endTime() {
        return this.endTime;
    }

    public final JobEndBehavior endBehavior() {
        return JobEndBehavior.fromValue(this.endBehavior);
    }

    public final String endBehaviorAsString() {
        return this.endBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchedulingConfig)) {
            return false;
        }
        SchedulingConfig other = (SchedulingConfig)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.endBehaviorAsString(), other.endBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SchedulingConfig").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("EndBehavior", (Object)this.endBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "endBehavior": {
                return Optional.ofNullable(clazz.cast(this.endBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchedulingConfig, T> g) {
        return obj -> g.apply((SchedulingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String startTime;
        private String endTime;
        private String endBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(SchedulingConfig model) {
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.endBehavior(model.endBehavior);
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getEndBehavior() {
            return this.endBehavior;
        }

        public final void setEndBehavior(String endBehavior) {
            this.endBehavior = endBehavior;
        }

        @Override
        public final Builder endBehavior(String endBehavior) {
            this.endBehavior = endBehavior;
            return this;
        }

        @Override
        public final Builder endBehavior(JobEndBehavior endBehavior) {
            this.endBehavior(endBehavior == null ? null : endBehavior.toString());
            return this;
        }

        public SchedulingConfig build() {
            return new SchedulingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchedulingConfig> {
        public Builder startTime(String var1);

        public Builder endTime(String var1);

        public Builder endBehavior(String var1);

        public Builder endBehavior(JobEndBehavior var1);
    }
}

