/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListPackageVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListPackageVersionsResponse;
import software.amazon.awssdk.services.iot.model.PackageVersionSummary;

public class ListPackageVersionsIterable
implements SdkIterable<ListPackageVersionsResponse> {
    private final IotClient client;
    private final ListPackageVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPackageVersionsIterable(IotClient client, ListPackageVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPackageVersionsResponseFetcher();
    }

    public Iterator<ListPackageVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PackageVersionSummary> packageVersionSummaries() {
        Function<ListPackageVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.packageVersionSummaries() != null) {
                return response.packageVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPackageVersionsResponseFetcher
    implements SyncPageFetcher<ListPackageVersionsResponse> {
        private ListPackageVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackageVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPackageVersionsResponse nextPage(ListPackageVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPackageVersionsIterable.this.client.listPackageVersions(ListPackageVersionsIterable.this.firstRequest);
            }
            return ListPackageVersionsIterable.this.client.listPackageVersions((ListPackageVersionsRequest)((Object)ListPackageVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

