/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListPackagesRequest;
import software.amazon.awssdk.services.iot.model.ListPackagesResponse;
import software.amazon.awssdk.services.iot.model.PackageSummary;

public class ListPackagesPublisher
implements SdkPublisher<ListPackagesResponse> {
    private final IotAsyncClient client;
    private final ListPackagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPackagesPublisher(IotAsyncClient client, ListPackagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPackagesPublisher(IotAsyncClient client, ListPackagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPackagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPackagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PackageSummary> packageSummaries() {
        Function<ListPackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.packageSummaries() != null) {
                return response.packageSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPackagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPackagesResponseFetcher
    implements AsyncPageFetcher<ListPackagesResponse> {
        private ListPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPackagesResponse> nextPage(ListPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListPackagesPublisher.this.client.listPackages(ListPackagesPublisher.this.firstRequest);
            }
            return ListPackagesPublisher.this.client.listPackages((ListPackagesRequest)((Object)ListPackagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

