/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListMetricValuesRequest;
import software.amazon.awssdk.services.iot.model.ListMetricValuesResponse;
import software.amazon.awssdk.services.iot.model.MetricDatum;

public class ListMetricValuesIterable
implements SdkIterable<ListMetricValuesResponse> {
    private final IotClient client;
    private final ListMetricValuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMetricValuesIterable(IotClient client, ListMetricValuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMetricValuesResponseFetcher();
    }

    public Iterator<ListMetricValuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MetricDatum> metricDatumList() {
        Function<ListMetricValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricDatumList() != null) {
                return response.metricDatumList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMetricValuesResponseFetcher
    implements SyncPageFetcher<ListMetricValuesResponse> {
        private ListMetricValuesResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMetricValuesResponse nextPage(ListMetricValuesResponse previousPage) {
            if (previousPage == null) {
                return ListMetricValuesIterable.this.client.listMetricValues(ListMetricValuesIterable.this.firstRequest);
            }
            return ListMetricValuesIterable.this.client.listMetricValues((ListMetricValuesRequest)((Object)ListMetricValuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

