/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskSummary;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksResponse;

public class ListDetectMitigationActionsTasksPublisher
implements SdkPublisher<ListDetectMitigationActionsTasksResponse> {
    private final IotAsyncClient client;
    private final ListDetectMitigationActionsTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDetectMitigationActionsTasksPublisher(IotAsyncClient client, ListDetectMitigationActionsTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDetectMitigationActionsTasksPublisher(IotAsyncClient client, ListDetectMitigationActionsTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDetectMitigationActionsTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDetectMitigationActionsTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DetectMitigationActionsTaskSummary> tasks() {
        Function<ListDetectMitigationActionsTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDetectMitigationActionsTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDetectMitigationActionsTasksResponseFetcher
    implements AsyncPageFetcher<ListDetectMitigationActionsTasksResponse> {
        private ListDetectMitigationActionsTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListDetectMitigationActionsTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDetectMitigationActionsTasksResponse> nextPage(ListDetectMitigationActionsTasksResponse previousPage) {
            if (previousPage == null) {
                return ListDetectMitigationActionsTasksPublisher.this.client.listDetectMitigationActionsTasks(ListDetectMitigationActionsTasksPublisher.this.firstRequest);
            }
            return ListDetectMitigationActionsTasksPublisher.this.client.listDetectMitigationActionsTasks((ListDetectMitigationActionsTasksRequest)((Object)ListDetectMitigationActionsTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

