/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.SecurityProfileTarget;

public class ListTargetsForSecurityProfilePublisher
implements SdkPublisher<ListTargetsForSecurityProfileResponse> {
    private final IotAsyncClient client;
    private final ListTargetsForSecurityProfileRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTargetsForSecurityProfilePublisher(IotAsyncClient client, ListTargetsForSecurityProfileRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTargetsForSecurityProfilePublisher(IotAsyncClient client, ListTargetsForSecurityProfileRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTargetsForSecurityProfileResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTargetsForSecurityProfileResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityProfileTarget> securityProfileTargets() {
        Function<ListTargetsForSecurityProfileResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityProfileTargets() != null) {
                return response.securityProfileTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTargetsForSecurityProfileResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTargetsForSecurityProfileResponseFetcher
    implements AsyncPageFetcher<ListTargetsForSecurityProfileResponse> {
        private ListTargetsForSecurityProfileResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetsForSecurityProfileResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTargetsForSecurityProfileResponse> nextPage(ListTargetsForSecurityProfileResponse previousPage) {
            if (previousPage == null) {
                return ListTargetsForSecurityProfilePublisher.this.client.listTargetsForSecurityProfile(ListTargetsForSecurityProfilePublisher.this.firstRequest);
            }
            return ListTargetsForSecurityProfilePublisher.this.client.listTargetsForSecurityProfile((ListTargetsForSecurityProfileRequest)((Object)ListTargetsForSecurityProfilePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

