/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListViolationEventsRequest;
import software.amazon.awssdk.services.iot.model.ListViolationEventsResponse;
import software.amazon.awssdk.services.iot.model.ViolationEvent;

public class ListViolationEventsIterable
implements SdkIterable<ListViolationEventsResponse> {
    private final IotClient client;
    private final ListViolationEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListViolationEventsIterable(IotClient client, ListViolationEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListViolationEventsResponseFetcher();
    }

    public Iterator<ListViolationEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ViolationEvent> violationEvents() {
        Function<ListViolationEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.violationEvents() != null) {
                return response.violationEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListViolationEventsResponseFetcher
    implements SyncPageFetcher<ListViolationEventsResponse> {
        private ListViolationEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListViolationEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListViolationEventsResponse nextPage(ListViolationEventsResponse previousPage) {
            if (previousPage == null) {
                return ListViolationEventsIterable.this.client.listViolationEvents(ListViolationEventsIterable.this.firstRequest);
            }
            return ListViolationEventsIterable.this.client.listViolationEvents((ListViolationEventsRequest)((Object)ListViolationEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

