/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.CertificateStatus;
import software.amazon.awssdk.services.iot.model.CertificateValidity;
import software.amazon.awssdk.services.iot.model.TransferData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateDescription> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDescription.getter(CertificateDescription::certificateArn)).setter(CertificateDescription.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDescription.getter(CertificateDescription::certificateId)).setter(CertificateDescription.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateId").build()}).build();
    private static final SdkField<String> CA_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDescription.getter(CertificateDescription::caCertificateId)).setter(CertificateDescription.setter(Builder::caCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caCertificateId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDescription.getter(CertificateDescription::statusAsString)).setter(CertificateDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDescription.getter(CertificateDescription::certificatePem)).setter(CertificateDescription.setter(Builder::certificatePem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()}).build();
    private static final SdkField<String> OWNED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDescription.getter(CertificateDescription::ownedBy)).setter(CertificateDescription.setter(Builder::ownedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownedBy").build()}).build();
    private static final SdkField<String> PREVIOUS_OWNED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDescription.getter(CertificateDescription::previousOwnedBy)).setter(CertificateDescription.setter(Builder::previousOwnedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousOwnedBy").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CertificateDescription.getter(CertificateDescription::creationDate)).setter(CertificateDescription.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CertificateDescription.getter(CertificateDescription::lastModifiedDate)).setter(CertificateDescription.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<Integer> CUSTOMER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CertificateDescription.getter(CertificateDescription::customerVersion)).setter(CertificateDescription.setter(Builder::customerVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerVersion").build()}).build();
    private static final SdkField<TransferData> TRANSFER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CertificateDescription.getter(CertificateDescription::transferData)).setter(CertificateDescription.setter(Builder::transferData)).constructor(TransferData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferData").build()}).build();
    private static final SdkField<String> GENERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDescription.getter(CertificateDescription::generationId)).setter(CertificateDescription.setter(Builder::generationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationId").build()}).build();
    private static final SdkField<CertificateValidity> VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CertificateDescription.getter(CertificateDescription::validity)).setter(CertificateDescription.setter(Builder::validity)).constructor(CertificateValidity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, CERTIFICATE_ID_FIELD, CA_CERTIFICATE_ID_FIELD, STATUS_FIELD, CERTIFICATE_PEM_FIELD, OWNED_BY_FIELD, PREVIOUS_OWNED_BY_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, CUSTOMER_VERSION_FIELD, TRANSFER_DATA_FIELD, GENERATION_ID_FIELD, VALIDITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificateArn;
    private final String certificateId;
    private final String caCertificateId;
    private final String status;
    private final String certificatePem;
    private final String ownedBy;
    private final String previousOwnedBy;
    private final Instant creationDate;
    private final Instant lastModifiedDate;
    private final Integer customerVersion;
    private final TransferData transferData;
    private final String generationId;
    private final CertificateValidity validity;

    private CertificateDescription(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.caCertificateId = builder.caCertificateId;
        this.status = builder.status;
        this.certificatePem = builder.certificatePem;
        this.ownedBy = builder.ownedBy;
        this.previousOwnedBy = builder.previousOwnedBy;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.customerVersion = builder.customerVersion;
        this.transferData = builder.transferData;
        this.generationId = builder.generationId;
        this.validity = builder.validity;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String caCertificateId() {
        return this.caCertificateId;
    }

    public CertificateStatus status() {
        return CertificateStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String certificatePem() {
        return this.certificatePem;
    }

    public String ownedBy() {
        return this.ownedBy;
    }

    public String previousOwnedBy() {
        return this.previousOwnedBy;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Integer customerVersion() {
        return this.customerVersion;
    }

    public TransferData transferData() {
        return this.transferData;
    }

    public String generationId() {
        return this.generationId;
    }

    public CertificateValidity validity() {
        return this.validity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousOwnedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferData());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.validity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateDescription)) {
            return false;
        }
        CertificateDescription other = (CertificateDescription)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.caCertificateId(), other.caCertificateId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.certificatePem(), other.certificatePem()) && Objects.equals(this.ownedBy(), other.ownedBy()) && Objects.equals(this.previousOwnedBy(), other.previousOwnedBy()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.customerVersion(), other.customerVersion()) && Objects.equals(this.transferData(), other.transferData()) && Objects.equals(this.generationId(), other.generationId()) && Objects.equals(this.validity(), other.validity());
    }

    public String toString() {
        return ToString.builder((String)"CertificateDescription").add("CertificateArn", (Object)this.certificateArn()).add("CertificateId", (Object)this.certificateId()).add("CaCertificateId", (Object)this.caCertificateId()).add("Status", (Object)this.statusAsString()).add("CertificatePem", (Object)this.certificatePem()).add("OwnedBy", (Object)this.ownedBy()).add("PreviousOwnedBy", (Object)this.previousOwnedBy()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("CustomerVersion", (Object)this.customerVersion()).add("TransferData", (Object)this.transferData()).add("GenerationId", (Object)this.generationId()).add("Validity", (Object)this.validity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "certificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "caCertificateId": {
                return Optional.ofNullable(clazz.cast(this.caCertificateId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "certificatePem": {
                return Optional.ofNullable(clazz.cast(this.certificatePem()));
            }
            case "ownedBy": {
                return Optional.ofNullable(clazz.cast(this.ownedBy()));
            }
            case "previousOwnedBy": {
                return Optional.ofNullable(clazz.cast(this.previousOwnedBy()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "customerVersion": {
                return Optional.ofNullable(clazz.cast(this.customerVersion()));
            }
            case "transferData": {
                return Optional.ofNullable(clazz.cast(this.transferData()));
            }
            case "generationId": {
                return Optional.ofNullable(clazz.cast(this.generationId()));
            }
            case "validity": {
                return Optional.ofNullable(clazz.cast(this.validity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateDescription, T> g) {
        return obj -> g.apply((CertificateDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String certificateId;
        private String caCertificateId;
        private String status;
        private String certificatePem;
        private String ownedBy;
        private String previousOwnedBy;
        private Instant creationDate;
        private Instant lastModifiedDate;
        private Integer customerVersion;
        private TransferData transferData;
        private String generationId;
        private CertificateValidity validity;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateDescription model) {
            this.certificateArn(model.certificateArn);
            this.certificateId(model.certificateId);
            this.caCertificateId(model.caCertificateId);
            this.status(model.status);
            this.certificatePem(model.certificatePem);
            this.ownedBy(model.ownedBy);
            this.previousOwnedBy(model.previousOwnedBy);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
            this.customerVersion(model.customerVersion);
            this.transferData(model.transferData);
            this.generationId(model.generationId);
            this.validity(model.validity);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCaCertificateId() {
            return this.caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getOwnedBy() {
            return this.ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        public final String getPreviousOwnedBy() {
            return this.previousOwnedBy;
        }

        @Override
        public final Builder previousOwnedBy(String previousOwnedBy) {
            this.previousOwnedBy = previousOwnedBy;
            return this;
        }

        public final void setPreviousOwnedBy(String previousOwnedBy) {
            this.previousOwnedBy = previousOwnedBy;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Integer getCustomerVersion() {
            return this.customerVersion;
        }

        @Override
        public final Builder customerVersion(Integer customerVersion) {
            this.customerVersion = customerVersion;
            return this;
        }

        public final void setCustomerVersion(Integer customerVersion) {
            this.customerVersion = customerVersion;
        }

        public final TransferData.Builder getTransferData() {
            return this.transferData != null ? this.transferData.toBuilder() : null;
        }

        @Override
        public final Builder transferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public final void setTransferData(TransferData.BuilderImpl transferData) {
            this.transferData = transferData != null ? transferData.build() : null;
        }

        public final String getGenerationId() {
            return this.generationId;
        }

        @Override
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        public final CertificateValidity.Builder getValidity() {
            return this.validity != null ? this.validity.toBuilder() : null;
        }

        @Override
        public final Builder validity(CertificateValidity validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(CertificateValidity.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        public CertificateDescription build() {
            return new CertificateDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateDescription> {
        public Builder certificateArn(String var1);

        public Builder certificateId(String var1);

        public Builder caCertificateId(String var1);

        public Builder status(String var1);

        public Builder status(CertificateStatus var1);

        public Builder certificatePem(String var1);

        public Builder ownedBy(String var1);

        public Builder previousOwnedBy(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder customerVersion(Integer var1);

        public Builder transferData(TransferData var1);

        default public Builder transferData(Consumer<TransferData.Builder> transferData) {
            return this.transferData((TransferData)((TransferData.Builder)TransferData.builder().applyMutation(transferData)).build());
        }

        public Builder generationId(String var1);

        public Builder validity(CertificateValidity var1);

        default public Builder validity(Consumer<CertificateValidity.Builder> validity) {
            return this.validity((CertificateValidity)((CertificateValidity.Builder)CertificateValidity.builder().applyMutation(validity)).build());
        }
    }
}

