/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AbortAction;
import software.amazon.awssdk.services.iot.model.JobExecutionFailureType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AbortCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AbortCriteria> {
    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AbortCriteria.getter(AbortCriteria::failureTypeAsString)).setter(AbortCriteria.setter(Builder::failureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureType").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AbortCriteria.getter(AbortCriteria::actionAsString)).setter(AbortCriteria.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<Double> THRESHOLD_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(AbortCriteria.getter(AbortCriteria::thresholdPercentage)).setter(AbortCriteria.setter(Builder::thresholdPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdPercentage").build()}).build();
    private static final SdkField<Integer> MIN_NUMBER_OF_EXECUTED_THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AbortCriteria.getter(AbortCriteria::minNumberOfExecutedThings)).setter(AbortCriteria.setter(Builder::minNumberOfExecutedThings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minNumberOfExecutedThings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_TYPE_FIELD, ACTION_FIELD, THRESHOLD_PERCENTAGE_FIELD, MIN_NUMBER_OF_EXECUTED_THINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String failureType;
    private final String action;
    private final Double thresholdPercentage;
    private final Integer minNumberOfExecutedThings;

    private AbortCriteria(BuilderImpl builder) {
        this.failureType = builder.failureType;
        this.action = builder.action;
        this.thresholdPercentage = builder.thresholdPercentage;
        this.minNumberOfExecutedThings = builder.minNumberOfExecutedThings;
    }

    public JobExecutionFailureType failureType() {
        return JobExecutionFailureType.fromValue(this.failureType);
    }

    public String failureTypeAsString() {
        return this.failureType;
    }

    public AbortAction action() {
        return AbortAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public Double thresholdPercentage() {
        return this.thresholdPercentage;
    }

    public Integer minNumberOfExecutedThings() {
        return this.minNumberOfExecutedThings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.minNumberOfExecutedThings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbortCriteria)) {
            return false;
        }
        AbortCriteria other = (AbortCriteria)obj;
        return Objects.equals(this.failureTypeAsString(), other.failureTypeAsString()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.thresholdPercentage(), other.thresholdPercentage()) && Objects.equals(this.minNumberOfExecutedThings(), other.minNumberOfExecutedThings());
    }

    public String toString() {
        return ToString.builder((String)"AbortCriteria").add("FailureType", (Object)this.failureTypeAsString()).add("Action", (Object)this.actionAsString()).add("ThresholdPercentage", (Object)this.thresholdPercentage()).add("MinNumberOfExecutedThings", (Object)this.minNumberOfExecutedThings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failureType": {
                return Optional.ofNullable(clazz.cast(this.failureTypeAsString()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "thresholdPercentage": {
                return Optional.ofNullable(clazz.cast(this.thresholdPercentage()));
            }
            case "minNumberOfExecutedThings": {
                return Optional.ofNullable(clazz.cast(this.minNumberOfExecutedThings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AbortCriteria, T> g) {
        return obj -> g.apply((AbortCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failureType;
        private String action;
        private Double thresholdPercentage;
        private Integer minNumberOfExecutedThings;

        private BuilderImpl() {
        }

        private BuilderImpl(AbortCriteria model) {
            this.failureType(model.failureType);
            this.action(model.action);
            this.thresholdPercentage(model.thresholdPercentage);
            this.minNumberOfExecutedThings(model.minNumberOfExecutedThings);
        }

        public final String getFailureType() {
            return this.failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(JobExecutionFailureType failureType) {
            this.failureType(failureType.toString());
            return this;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(AbortAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Double getThresholdPercentage() {
            return this.thresholdPercentage;
        }

        @Override
        public final Builder thresholdPercentage(Double thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
            return this;
        }

        public final void setThresholdPercentage(Double thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
        }

        public final Integer getMinNumberOfExecutedThings() {
            return this.minNumberOfExecutedThings;
        }

        @Override
        public final Builder minNumberOfExecutedThings(Integer minNumberOfExecutedThings) {
            this.minNumberOfExecutedThings = minNumberOfExecutedThings;
            return this;
        }

        public final void setMinNumberOfExecutedThings(Integer minNumberOfExecutedThings) {
            this.minNumberOfExecutedThings = minNumberOfExecutedThings;
        }

        public AbortCriteria build() {
            return new AbortCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AbortCriteria> {
        public Builder failureType(String var1);

        public Builder failureType(JobExecutionFailureType var1);

        public Builder action(String var1);

        public Builder action(AbortAction var1);

        public Builder thresholdPercentage(Double var1);

        public Builder minNumberOfExecutedThings(Integer var1);
    }
}

