/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsResponse;

public class ListThingRegistrationTaskReportsPublisher
implements SdkPublisher<ListThingRegistrationTaskReportsResponse> {
    private final IotAsyncClient client;
    private final ListThingRegistrationTaskReportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThingRegistrationTaskReportsPublisher(IotAsyncClient client, ListThingRegistrationTaskReportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThingRegistrationTaskReportsPublisher(IotAsyncClient client, ListThingRegistrationTaskReportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThingRegistrationTaskReportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThingRegistrationTaskReportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> resourceLinks() {
        Function<ListThingRegistrationTaskReportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceLinks() != null) {
                return response.resourceLinks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThingRegistrationTaskReportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListThingRegistrationTaskReportsResponseFetcher
    implements AsyncPageFetcher<ListThingRegistrationTaskReportsResponse> {
        private ListThingRegistrationTaskReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListThingRegistrationTaskReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThingRegistrationTaskReportsResponse> nextPage(ListThingRegistrationTaskReportsResponse previousPage) {
            if (previousPage == null) {
                return ListThingRegistrationTaskReportsPublisher.this.client.listThingRegistrationTaskReports(ListThingRegistrationTaskReportsPublisher.this.firstRequest);
            }
            return ListThingRegistrationTaskReportsPublisher.this.client.listThingRegistrationTaskReports((ListThingRegistrationTaskReportsRequest)((Object)ListThingRegistrationTaskReportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

