/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetResponse;
import software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping;

public class ListSecurityProfilesForTargetPublisher
implements SdkPublisher<ListSecurityProfilesForTargetResponse> {
    private final IotAsyncClient client;
    private final ListSecurityProfilesForTargetRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityProfilesForTargetPublisher(IotAsyncClient client, ListSecurityProfilesForTargetRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityProfilesForTargetPublisher(IotAsyncClient client, ListSecurityProfilesForTargetRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityProfilesForTargetResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityProfilesForTargetResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityProfileTargetMapping> securityProfileTargetMappings() {
        Function<ListSecurityProfilesForTargetResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityProfileTargetMappings() != null) {
                return response.securityProfileTargetMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSecurityProfilesForTargetResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSecurityProfilesForTargetResponseFetcher
    implements AsyncPageFetcher<ListSecurityProfilesForTargetResponse> {
        private ListSecurityProfilesForTargetResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityProfilesForTargetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSecurityProfilesForTargetResponse> nextPage(ListSecurityProfilesForTargetResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityProfilesForTargetPublisher.this.client.listSecurityProfilesForTarget(ListSecurityProfilesForTargetPublisher.this.firstRequest);
            }
            return ListSecurityProfilesForTargetPublisher.this.client.listSecurityProfilesForTarget((ListSecurityProfilesForTargetRequest)((Object)ListSecurityProfilesForTargetPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

