/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ManagedJobTemplateSummary;
import software.amazon.awssdk.services.iot.model.ManagedJobTemplatesSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListManagedJobTemplatesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListManagedJobTemplatesResponse> {
    private static final SdkField<List<ManagedJobTemplateSummary>> MANAGED_JOB_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedJobTemplates").getter(ListManagedJobTemplatesResponse.getter(ListManagedJobTemplatesResponse::managedJobTemplates)).setter(ListManagedJobTemplatesResponse.setter(Builder::managedJobTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedJobTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedJobTemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListManagedJobTemplatesResponse.getter(ListManagedJobTemplatesResponse::nextToken)).setter(ListManagedJobTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_JOB_TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ManagedJobTemplateSummary> managedJobTemplates;
    private final String nextToken;

    private ListManagedJobTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.managedJobTemplates = builder.managedJobTemplates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasManagedJobTemplates() {
        return this.managedJobTemplates != null && !(this.managedJobTemplates instanceof SdkAutoConstructList);
    }

    public final List<ManagedJobTemplateSummary> managedJobTemplates() {
        return this.managedJobTemplates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedJobTemplates() ? this.managedJobTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedJobTemplatesResponse)) {
            return false;
        }
        ListManagedJobTemplatesResponse other = (ListManagedJobTemplatesResponse)((Object)obj);
        return this.hasManagedJobTemplates() == other.hasManagedJobTemplates() && Objects.equals(this.managedJobTemplates(), other.managedJobTemplates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListManagedJobTemplatesResponse").add("ManagedJobTemplates", this.hasManagedJobTemplates() ? this.managedJobTemplates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "managedJobTemplates": {
                return Optional.ofNullable(clazz.cast(this.managedJobTemplates()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListManagedJobTemplatesResponse, T> g) {
        return obj -> g.apply((ListManagedJobTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<ManagedJobTemplateSummary> managedJobTemplates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedJobTemplatesResponse model) {
            super(model);
            this.managedJobTemplates(model.managedJobTemplates);
            this.nextToken(model.nextToken);
        }

        public final List<ManagedJobTemplateSummary.Builder> getManagedJobTemplates() {
            List<ManagedJobTemplateSummary.Builder> result = ManagedJobTemplatesSummaryListCopier.copyToBuilder(this.managedJobTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedJobTemplates(Collection<ManagedJobTemplateSummary.BuilderImpl> managedJobTemplates) {
            this.managedJobTemplates = ManagedJobTemplatesSummaryListCopier.copyFromBuilder(managedJobTemplates);
        }

        @Override
        @Transient
        public final Builder managedJobTemplates(Collection<ManagedJobTemplateSummary> managedJobTemplates) {
            this.managedJobTemplates = ManagedJobTemplatesSummaryListCopier.copy(managedJobTemplates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder managedJobTemplates(ManagedJobTemplateSummary ... managedJobTemplates) {
            this.managedJobTemplates(Arrays.asList(managedJobTemplates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder managedJobTemplates(Consumer<ManagedJobTemplateSummary.Builder> ... managedJobTemplates) {
            this.managedJobTemplates(Stream.of(managedJobTemplates).map(c -> (ManagedJobTemplateSummary)((ManagedJobTemplateSummary.Builder)ManagedJobTemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListManagedJobTemplatesResponse build() {
            return new ListManagedJobTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListManagedJobTemplatesResponse> {
        public Builder managedJobTemplates(Collection<ManagedJobTemplateSummary> var1);

        public Builder managedJobTemplates(ManagedJobTemplateSummary ... var1);

        public Builder managedJobTemplates(Consumer<ManagedJobTemplateSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

