/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AuditCheckRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditCheckDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditCheckDetails> {
    private static final SdkField<String> CHECK_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checkRunStatus").getter(AuditCheckDetails.getter(AuditCheckDetails::checkRunStatusAsString)).setter(AuditCheckDetails.setter(Builder::checkRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkRunStatus").build()}).build();
    private static final SdkField<Boolean> CHECK_COMPLIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("checkCompliant").getter(AuditCheckDetails.getter(AuditCheckDetails::checkCompliant)).setter(AuditCheckDetails.setter(Builder::checkCompliant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkCompliant").build()}).build();
    private static final SdkField<Long> TOTAL_RESOURCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalResourcesCount").getter(AuditCheckDetails.getter(AuditCheckDetails::totalResourcesCount)).setter(AuditCheckDetails.setter(Builder::totalResourcesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResourcesCount").build()}).build();
    private static final SdkField<Long> NON_COMPLIANT_RESOURCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("nonCompliantResourcesCount").getter(AuditCheckDetails.getter(AuditCheckDetails::nonCompliantResourcesCount)).setter(AuditCheckDetails.setter(Builder::nonCompliantResourcesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonCompliantResourcesCount").build()}).build();
    private static final SdkField<Long> SUPPRESSED_NON_COMPLIANT_RESOURCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("suppressedNonCompliantResourcesCount").getter(AuditCheckDetails.getter(AuditCheckDetails::suppressedNonCompliantResourcesCount)).setter(AuditCheckDetails.setter(Builder::suppressedNonCompliantResourcesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressedNonCompliantResourcesCount").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(AuditCheckDetails.getter(AuditCheckDetails::errorCode)).setter(AuditCheckDetails.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(AuditCheckDetails.getter(AuditCheckDetails::message)).setter(AuditCheckDetails.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_RUN_STATUS_FIELD, CHECK_COMPLIANT_FIELD, TOTAL_RESOURCES_COUNT_FIELD, NON_COMPLIANT_RESOURCES_COUNT_FIELD, SUPPRESSED_NON_COMPLIANT_RESOURCES_COUNT_FIELD, ERROR_CODE_FIELD, MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String checkRunStatus;
    private final Boolean checkCompliant;
    private final Long totalResourcesCount;
    private final Long nonCompliantResourcesCount;
    private final Long suppressedNonCompliantResourcesCount;
    private final String errorCode;
    private final String message;

    private AuditCheckDetails(BuilderImpl builder) {
        this.checkRunStatus = builder.checkRunStatus;
        this.checkCompliant = builder.checkCompliant;
        this.totalResourcesCount = builder.totalResourcesCount;
        this.nonCompliantResourcesCount = builder.nonCompliantResourcesCount;
        this.suppressedNonCompliantResourcesCount = builder.suppressedNonCompliantResourcesCount;
        this.errorCode = builder.errorCode;
        this.message = builder.message;
    }

    public final AuditCheckRunStatus checkRunStatus() {
        return AuditCheckRunStatus.fromValue(this.checkRunStatus);
    }

    public final String checkRunStatusAsString() {
        return this.checkRunStatus;
    }

    public final Boolean checkCompliant() {
        return this.checkCompliant;
    }

    public final Long totalResourcesCount() {
        return this.totalResourcesCount;
    }

    public final Long nonCompliantResourcesCount() {
        return this.nonCompliantResourcesCount;
    }

    public final Long suppressedNonCompliantResourcesCount() {
        return this.suppressedNonCompliantResourcesCount;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checkRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkCompliant());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressedNonCompliantResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditCheckDetails)) {
            return false;
        }
        AuditCheckDetails other = (AuditCheckDetails)obj;
        return Objects.equals(this.checkRunStatusAsString(), other.checkRunStatusAsString()) && Objects.equals(this.checkCompliant(), other.checkCompliant()) && Objects.equals(this.totalResourcesCount(), other.totalResourcesCount()) && Objects.equals(this.nonCompliantResourcesCount(), other.nonCompliantResourcesCount()) && Objects.equals(this.suppressedNonCompliantResourcesCount(), other.suppressedNonCompliantResourcesCount()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"AuditCheckDetails").add("CheckRunStatus", (Object)this.checkRunStatusAsString()).add("CheckCompliant", (Object)this.checkCompliant()).add("TotalResourcesCount", (Object)this.totalResourcesCount()).add("NonCompliantResourcesCount", (Object)this.nonCompliantResourcesCount()).add("SuppressedNonCompliantResourcesCount", (Object)this.suppressedNonCompliantResourcesCount()).add("ErrorCode", (Object)this.errorCode()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checkRunStatus": {
                return Optional.ofNullable(clazz.cast(this.checkRunStatusAsString()));
            }
            case "checkCompliant": {
                return Optional.ofNullable(clazz.cast(this.checkCompliant()));
            }
            case "totalResourcesCount": {
                return Optional.ofNullable(clazz.cast(this.totalResourcesCount()));
            }
            case "nonCompliantResourcesCount": {
                return Optional.ofNullable(clazz.cast(this.nonCompliantResourcesCount()));
            }
            case "suppressedNonCompliantResourcesCount": {
                return Optional.ofNullable(clazz.cast(this.suppressedNonCompliantResourcesCount()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditCheckDetails, T> g) {
        return obj -> g.apply((AuditCheckDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String checkRunStatus;
        private Boolean checkCompliant;
        private Long totalResourcesCount;
        private Long nonCompliantResourcesCount;
        private Long suppressedNonCompliantResourcesCount;
        private String errorCode;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditCheckDetails model) {
            this.checkRunStatus(model.checkRunStatus);
            this.checkCompliant(model.checkCompliant);
            this.totalResourcesCount(model.totalResourcesCount);
            this.nonCompliantResourcesCount(model.nonCompliantResourcesCount);
            this.suppressedNonCompliantResourcesCount(model.suppressedNonCompliantResourcesCount);
            this.errorCode(model.errorCode);
            this.message(model.message);
        }

        public final String getCheckRunStatus() {
            return this.checkRunStatus;
        }

        public final void setCheckRunStatus(String checkRunStatus) {
            this.checkRunStatus = checkRunStatus;
        }

        @Override
        @Transient
        public final Builder checkRunStatus(String checkRunStatus) {
            this.checkRunStatus = checkRunStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder checkRunStatus(AuditCheckRunStatus checkRunStatus) {
            this.checkRunStatus(checkRunStatus == null ? null : checkRunStatus.toString());
            return this;
        }

        public final Boolean getCheckCompliant() {
            return this.checkCompliant;
        }

        public final void setCheckCompliant(Boolean checkCompliant) {
            this.checkCompliant = checkCompliant;
        }

        @Override
        @Transient
        public final Builder checkCompliant(Boolean checkCompliant) {
            this.checkCompliant = checkCompliant;
            return this;
        }

        public final Long getTotalResourcesCount() {
            return this.totalResourcesCount;
        }

        public final void setTotalResourcesCount(Long totalResourcesCount) {
            this.totalResourcesCount = totalResourcesCount;
        }

        @Override
        @Transient
        public final Builder totalResourcesCount(Long totalResourcesCount) {
            this.totalResourcesCount = totalResourcesCount;
            return this;
        }

        public final Long getNonCompliantResourcesCount() {
            return this.nonCompliantResourcesCount;
        }

        public final void setNonCompliantResourcesCount(Long nonCompliantResourcesCount) {
            this.nonCompliantResourcesCount = nonCompliantResourcesCount;
        }

        @Override
        @Transient
        public final Builder nonCompliantResourcesCount(Long nonCompliantResourcesCount) {
            this.nonCompliantResourcesCount = nonCompliantResourcesCount;
            return this;
        }

        public final Long getSuppressedNonCompliantResourcesCount() {
            return this.suppressedNonCompliantResourcesCount;
        }

        public final void setSuppressedNonCompliantResourcesCount(Long suppressedNonCompliantResourcesCount) {
            this.suppressedNonCompliantResourcesCount = suppressedNonCompliantResourcesCount;
        }

        @Override
        @Transient
        public final Builder suppressedNonCompliantResourcesCount(Long suppressedNonCompliantResourcesCount) {
            this.suppressedNonCompliantResourcesCount = suppressedNonCompliantResourcesCount;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        @Transient
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public AuditCheckDetails build() {
            return new AuditCheckDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditCheckDetails> {
        public Builder checkRunStatus(String var1);

        public Builder checkRunStatus(AuditCheckRunStatus var1);

        public Builder checkCompliant(Boolean var1);

        public Builder totalResourcesCount(Long var1);

        public Builder nonCompliantResourcesCount(Long var1);

        public Builder suppressedNonCompliantResourcesCount(Long var1);

        public Builder errorCode(String var1);

        public Builder message(String var1);
    }
}

