/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.LogLevel;
import software.amazon.awssdk.services.iot.model.LogTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogTargetConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogTargetConfiguration> {
    private static final SdkField<LogTarget> LOG_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logTarget").getter(LogTargetConfiguration.getter(LogTargetConfiguration::logTarget)).setter(LogTargetConfiguration.setter(Builder::logTarget)).constructor(LogTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logTarget").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logLevel").getter(LogTargetConfiguration.getter(LogTargetConfiguration::logLevelAsString)).setter(LogTargetConfiguration.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TARGET_FIELD, LOG_LEVEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final LogTarget logTarget;
    private final String logLevel;

    private LogTargetConfiguration(BuilderImpl builder) {
        this.logTarget = builder.logTarget;
        this.logLevel = builder.logLevel;
    }

    public final LogTarget logTarget() {
        return this.logTarget;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogTargetConfiguration)) {
            return false;
        }
        LogTargetConfiguration other = (LogTargetConfiguration)obj;
        return Objects.equals(this.logTarget(), other.logTarget()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LogTargetConfiguration").add("LogTarget", (Object)this.logTarget()).add("LogLevel", (Object)this.logLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logTarget": {
                return Optional.ofNullable(clazz.cast(this.logTarget()));
            }
            case "logLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogTargetConfiguration, T> g) {
        return obj -> g.apply((LogTargetConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LogTarget logTarget;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(LogTargetConfiguration model) {
            this.logTarget(model.logTarget);
            this.logLevel(model.logLevel);
        }

        public final LogTarget.Builder getLogTarget() {
            return this.logTarget != null ? this.logTarget.toBuilder() : null;
        }

        public final void setLogTarget(LogTarget.BuilderImpl logTarget) {
            this.logTarget = logTarget != null ? logTarget.build() : null;
        }

        @Override
        @Transient
        public final Builder logTarget(LogTarget logTarget) {
            this.logTarget = logTarget;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        @Transient
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        @Transient
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public LogTargetConfiguration build() {
            return new LogTargetConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogTargetConfiguration> {
        public Builder logTarget(LogTarget var1);

        default public Builder logTarget(Consumer<LogTarget.Builder> logTarget) {
            return this.logTarget((LogTarget)((LogTarget.Builder)LogTarget.builder().applyMutation(logTarget)).build());
        }

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);
    }
}

