/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuditSuppression;
import software.amazon.awssdk.services.iot.model.AuditSuppressionListCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAuditSuppressionsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListAuditSuppressionsResponse> {
    private static final SdkField<List<AuditSuppression>> SUPPRESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("suppressions").getter(ListAuditSuppressionsResponse.getter(ListAuditSuppressionsResponse::suppressions)).setter(ListAuditSuppressionsResponse.setter(Builder::suppressions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditSuppression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAuditSuppressionsResponse.getter(ListAuditSuppressionsResponse::nextToken)).setter(ListAuditSuppressionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPRESSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AuditSuppression> suppressions;
    private final String nextToken;

    private ListAuditSuppressionsResponse(BuilderImpl builder) {
        super(builder);
        this.suppressions = builder.suppressions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSuppressions() {
        return this.suppressions != null && !(this.suppressions instanceof SdkAutoConstructList);
    }

    public final List<AuditSuppression> suppressions() {
        return this.suppressions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuppressions() ? this.suppressions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditSuppressionsResponse)) {
            return false;
        }
        ListAuditSuppressionsResponse other = (ListAuditSuppressionsResponse)((Object)obj);
        return this.hasSuppressions() == other.hasSuppressions() && Objects.equals(this.suppressions(), other.suppressions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAuditSuppressionsResponse").add("Suppressions", this.hasSuppressions() ? this.suppressions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "suppressions": {
                return Optional.ofNullable(clazz.cast(this.suppressions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditSuppressionsResponse, T> g) {
        return obj -> g.apply((ListAuditSuppressionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<AuditSuppression> suppressions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditSuppressionsResponse model) {
            super(model);
            this.suppressions(model.suppressions);
            this.nextToken(model.nextToken);
        }

        public final List<AuditSuppression.Builder> getSuppressions() {
            List<AuditSuppression.Builder> result = AuditSuppressionListCopier.copyToBuilder(this.suppressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuppressions(Collection<AuditSuppression.BuilderImpl> suppressions) {
            this.suppressions = AuditSuppressionListCopier.copyFromBuilder(suppressions);
        }

        @Override
        @Transient
        public final Builder suppressions(Collection<AuditSuppression> suppressions) {
            this.suppressions = AuditSuppressionListCopier.copy(suppressions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder suppressions(AuditSuppression ... suppressions) {
            this.suppressions(Arrays.asList(suppressions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder suppressions(Consumer<AuditSuppression.Builder> ... suppressions) {
            this.suppressions(Stream.of(suppressions).map(c -> (AuditSuppression)((AuditSuppression.Builder)AuditSuppression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAuditSuppressionsResponse build() {
            return new ListAuditSuppressionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAuditSuppressionsResponse> {
        public Builder suppressions(Collection<AuditSuppression> var1);

        public Builder suppressions(AuditSuppression ... var1);

        public Builder suppressions(Consumer<AuditSuppression.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

