/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.DetectMitigationActionExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectMitigationActionExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectMitigationActionExecution> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(DetectMitigationActionExecution.getter(DetectMitigationActionExecution::taskId)).setter(DetectMitigationActionExecution.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> VIOLATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("violationId").getter(DetectMitigationActionExecution.getter(DetectMitigationActionExecution::violationId)).setter(DetectMitigationActionExecution.setter(Builder::violationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationId").build()}).build();
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(DetectMitigationActionExecution.getter(DetectMitigationActionExecution::actionName)).setter(DetectMitigationActionExecution.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(DetectMitigationActionExecution.getter(DetectMitigationActionExecution::thingName)).setter(DetectMitigationActionExecution.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<Instant> EXECUTION_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("executionStartDate").getter(DetectMitigationActionExecution.getter(DetectMitigationActionExecution::executionStartDate)).setter(DetectMitigationActionExecution.setter(Builder::executionStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartDate").build()}).build();
    private static final SdkField<Instant> EXECUTION_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("executionEndDate").getter(DetectMitigationActionExecution.getter(DetectMitigationActionExecution::executionEndDate)).setter(DetectMitigationActionExecution.setter(Builder::executionEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionEndDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DetectMitigationActionExecution.getter(DetectMitigationActionExecution::statusAsString)).setter(DetectMitigationActionExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(DetectMitigationActionExecution.getter(DetectMitigationActionExecution::errorCode)).setter(DetectMitigationActionExecution.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(DetectMitigationActionExecution.getter(DetectMitigationActionExecution::message)).setter(DetectMitigationActionExecution.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, VIOLATION_ID_FIELD, ACTION_NAME_FIELD, THING_NAME_FIELD, EXECUTION_START_DATE_FIELD, EXECUTION_END_DATE_FIELD, STATUS_FIELD, ERROR_CODE_FIELD, MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String violationId;
    private final String actionName;
    private final String thingName;
    private final Instant executionStartDate;
    private final Instant executionEndDate;
    private final String status;
    private final String errorCode;
    private final String message;

    private DetectMitigationActionExecution(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.violationId = builder.violationId;
        this.actionName = builder.actionName;
        this.thingName = builder.thingName;
        this.executionStartDate = builder.executionStartDate;
        this.executionEndDate = builder.executionEndDate;
        this.status = builder.status;
        this.errorCode = builder.errorCode;
        this.message = builder.message;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String violationId() {
        return this.violationId;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final Instant executionStartDate() {
        return this.executionStartDate;
    }

    public final Instant executionEndDate() {
        return this.executionEndDate;
    }

    public final DetectMitigationActionExecutionStatus status() {
        return DetectMitigationActionExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.violationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectMitigationActionExecution)) {
            return false;
        }
        DetectMitigationActionExecution other = (DetectMitigationActionExecution)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.violationId(), other.violationId()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.executionStartDate(), other.executionStartDate()) && Objects.equals(this.executionEndDate(), other.executionEndDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"DetectMitigationActionExecution").add("TaskId", (Object)this.taskId()).add("ViolationId", (Object)this.violationId()).add("ActionName", (Object)this.actionName()).add("ThingName", (Object)this.thingName()).add("ExecutionStartDate", (Object)this.executionStartDate()).add("ExecutionEndDate", (Object)this.executionEndDate()).add("Status", (Object)this.statusAsString()).add("ErrorCode", (Object)this.errorCode()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "violationId": {
                return Optional.ofNullable(clazz.cast(this.violationId()));
            }
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "executionStartDate": {
                return Optional.ofNullable(clazz.cast(this.executionStartDate()));
            }
            case "executionEndDate": {
                return Optional.ofNullable(clazz.cast(this.executionEndDate()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectMitigationActionExecution, T> g) {
        return obj -> g.apply((DetectMitigationActionExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String violationId;
        private String actionName;
        private String thingName;
        private Instant executionStartDate;
        private Instant executionEndDate;
        private String status;
        private String errorCode;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectMitigationActionExecution model) {
            this.taskId(model.taskId);
            this.violationId(model.violationId);
            this.actionName(model.actionName);
            this.thingName(model.thingName);
            this.executionStartDate(model.executionStartDate);
            this.executionEndDate(model.executionEndDate);
            this.status(model.status);
            this.errorCode(model.errorCode);
            this.message(model.message);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        @Transient
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getViolationId() {
            return this.violationId;
        }

        public final void setViolationId(String violationId) {
            this.violationId = violationId;
        }

        @Override
        @Transient
        public final Builder violationId(String violationId) {
            this.violationId = violationId;
            return this;
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        @Transient
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getThingName() {
            return this.thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        @Transient
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final Instant getExecutionStartDate() {
            return this.executionStartDate;
        }

        public final void setExecutionStartDate(Instant executionStartDate) {
            this.executionStartDate = executionStartDate;
        }

        @Override
        @Transient
        public final Builder executionStartDate(Instant executionStartDate) {
            this.executionStartDate = executionStartDate;
            return this;
        }

        public final Instant getExecutionEndDate() {
            return this.executionEndDate;
        }

        public final void setExecutionEndDate(Instant executionEndDate) {
            this.executionEndDate = executionEndDate;
        }

        @Override
        @Transient
        public final Builder executionEndDate(Instant executionEndDate) {
            this.executionEndDate = executionEndDate;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(DetectMitigationActionExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        @Transient
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public DetectMitigationActionExecution build() {
            return new DetectMitigationActionExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectMitigationActionExecution> {
        public Builder taskId(String var1);

        public Builder violationId(String var1);

        public Builder actionName(String var1);

        public Builder thingName(String var1);

        public Builder executionStartDate(Instant var1);

        public Builder executionEndDate(Instant var1);

        public Builder status(String var1);

        public Builder status(DetectMitigationActionExecutionStatus var1);

        public Builder errorCode(String var1);

        public Builder message(String var1);
    }
}

