/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudwatchAlarmAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudwatchAlarmAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CloudwatchAlarmAction.getter(CloudwatchAlarmAction::roleArn)).setter(CloudwatchAlarmAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmName").getter(CloudwatchAlarmAction.getter(CloudwatchAlarmAction::alarmName)).setter(CloudwatchAlarmAction.setter(Builder::alarmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmName").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateReason").getter(CloudwatchAlarmAction.getter(CloudwatchAlarmAction::stateReason)).setter(CloudwatchAlarmAction.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateReason").build()}).build();
    private static final SdkField<String> STATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateValue").getter(CloudwatchAlarmAction.getter(CloudwatchAlarmAction::stateValue)).setter(CloudwatchAlarmAction.setter(Builder::stateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, ALARM_NAME_FIELD, STATE_REASON_FIELD, STATE_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String alarmName;
    private final String stateReason;
    private final String stateValue;

    private CloudwatchAlarmAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.alarmName = builder.alarmName;
        this.stateReason = builder.stateReason;
        this.stateValue = builder.stateValue;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String alarmName() {
        return this.alarmName;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final String stateValue() {
        return this.stateValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudwatchAlarmAction)) {
            return false;
        }
        CloudwatchAlarmAction other = (CloudwatchAlarmAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.stateValue(), other.stateValue());
    }

    public final String toString() {
        return ToString.builder((String)"CloudwatchAlarmAction").add("RoleArn", (Object)this.roleArn()).add("AlarmName", (Object)this.alarmName()).add("StateReason", (Object)this.stateReason()).add("StateValue", (Object)this.stateValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "alarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "stateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "stateValue": {
                return Optional.ofNullable(clazz.cast(this.stateValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudwatchAlarmAction, T> g) {
        return obj -> g.apply((CloudwatchAlarmAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String alarmName;
        private String stateReason;
        private String stateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudwatchAlarmAction model) {
            this.roleArn(model.roleArn);
            this.alarmName(model.alarmName);
            this.stateReason(model.stateReason);
            this.stateValue(model.stateValue);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        @Transient
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        @Transient
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getStateValue() {
            return this.stateValue;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        @Override
        @Transient
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        public CloudwatchAlarmAction build() {
            return new CloudwatchAlarmAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudwatchAlarmAction> {
        public Builder roleArn(String var1);

        public Builder alarmName(String var1);

        public Builder stateReason(String var1);

        public Builder stateValue(String var1);
    }
}

